/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.CraftNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.IngredientNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.ItemNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.Node;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.RecipeUtil;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class GeneratorGraph
implements ICachableGeneratorGraph,
IDebugContextSetter {
    private CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;
    protected final int MAX_PRE_TICK = 50;
    public final List<CraftGuideData> craftGuides = new ArrayList<CraftGuideData>();
    private final RegistryAccess registryAccess;
    public int pushedSteps = 0;
    public int processedSteps = 0;
    List<Node> nodes;
    HashMap<ResourceLocation, List<ItemNode>> itemNodeMap = new HashMap();
    HashMap<ResourceLocation, CraftNode> craftNodeMap = new HashMap();
    HashMap<UUID, IngredientNode> cachedIngredients = new HashMap();
    Set<ResourceLocation> notToAddRecipe = new HashSet<ResourceLocation>();
    Set<ResourceLocation> notToAddType = new HashSet<ResourceLocation>();
    protected ResourceLocation currentType;
    protected boolean oneTime = false;
    Queue<Node> queue = new LinkedList<Node>();
    Queue<Node> reversedQueue = new LinkedList<Node>();
    Queue<AddRecipeData> addRecipeQueue = new LinkedList<AddRecipeData>();

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
    }

    @Override
    public Node getNode(int a) {
        return this.nodes.get(a);
    }

    public GeneratorGraph(RegistryAccess registryAccess) {
        this.registryAccess = registryAccess;
        this.nodes = new ArrayList<Node>();
        IngredientNode ingredientNode = this.addOrGetIngredientNode(Ingredient.f_43901_);
        this.queue.add(ingredientNode);
        ingredientNode.related = true;
    }

    @Override
    public void setItems(List<ItemStack> items, List<ItemStack> required) {
        ItemNode itemNode;
        for (ItemStack item : items) {
            itemNode = this.getItemNodeOrCreate(item, false);
            this.queue.add(itemNode);
            if (!item.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) continue;
            CraftGuideData craftGuideData = CraftGuideData.fromItemStack(item);
            craftGuideData.getOutput().forEach(itemStack -> this.queue.add(this.getItemNodeOrCreate((ItemStack)itemStack, false)));
        }
        for (ItemStack item : required) {
            itemNode = this.getItemNodeOrCreate(item, false);
            this.reversedQueue.add(itemNode);
        }
    }

    @NotNull
    public ItemNode getItemNodeOrCreate(ItemStack itemStack, boolean available) {
        ItemNode tmp = this.getItemNode(itemStack);
        if (tmp == null) {
            tmp = this.addItemNode(itemStack, available);
        }
        return tmp;
    }

    public ItemNode getItemNode(ItemStack itemStack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (this.itemNodeMap.containsKey(id)) {
            for (Node node : this.itemNodeMap.get(id)) {
                if (!(node instanceof ItemNode)) continue;
                ItemNode in = (ItemNode)node;
                if (!ItemStackUtil.isSameInCrafting(itemStack, in.itemStack)) continue;
                return in;
            }
        }
        return null;
    }

    public ItemNode addItemNode(ItemStack itemStack, boolean available) {
        ItemNode itemNode = new ItemNode(this.nodes.size(), available, itemStack);
        this.nodes.add(itemNode);
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (!this.itemNodeMap.containsKey(id)) {
            this.itemNodeMap.put(id, new ArrayList());
        }
        this.itemNodeMap.get(id).add(itemNode);
        return itemNode;
    }

    public IngredientNode addOrGetIngredientNode(Ingredient ingredient) {
        for (Node node : this.nodes) {
            IngredientNode in;
            if (!(node instanceof IngredientNode) || !(in = (IngredientNode)node).isEqualTo(ingredient)) continue;
            return in;
        }
        return this.addIngredientNode(ingredient);
    }

    @Override
    public IngredientNode addOrGetCahcedIngredientNode(Ingredient ingredient, UUID uuid) {
        if (ingredient.m_43947_()) {
            return this.addOrGetIngredientNode(ingredient);
        }
        if (this.cachedIngredients.containsKey(uuid)) {
            return this.cachedIngredients.get(uuid);
        }
        IngredientNode ingredientNode = this.addIngredientNode(ingredient);
        this.cachedIngredients.put(uuid, ingredientNode);
        return ingredientNode;
    }

    private IngredientNode addIngredientNode(Ingredient ingredient) {
        List<ItemNode> possibleItems = Arrays.stream(ingredient.m_43908_()).map(t -> this.getItemNodeOrCreate((ItemStack)t, false)).toList();
        IngredientNode ingredientNode = new IngredientNode(this.nodes.size(), possibleItems);
        this.nodes.add(ingredientNode);
        for (ItemNode itemNode : possibleItems) {
            itemNode.addEdge(ingredientNode, 1);
        }
        return ingredientNode;
    }

    @Override
    public void setCurrentGeneratorType(IAutoCraftGuideGenerator generator) {
        this.currentType = generator.getType();
        this.oneTime = generator.canCacheGraph();
    }

    @Override
    public void setCurrentGeneratorType(ResourceLocation internalType, boolean b) {
        this.currentType = internalType;
        this.oneTime = b;
    }

    @Override
    public void addRecipe(Recipe<?> recipe, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier) {
        List<Integer> ingredientCounts = recipe.m_7527_().stream().map(t -> Arrays.stream(t.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(1)).toList();
        this.addRecipe(recipe.m_6423_(), (List<Ingredient>)recipe.m_7527_(), ingredientCounts, recipe.m_8043_(this.registryAccess), craftGuideSupplier);
        ++this.pushedSteps;
    }

    @Override
    public void addRecipeWrapId(Recipe<?> recipe, ResourceLocation generator, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier) {
        List<Integer> ingredientCounts = recipe.m_7527_().stream().map(t -> Arrays.stream(t.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(1)).toList();
        this.addRecipe(RecipeUtil.wrapLocation(generator, recipe.m_6423_()), (List<Ingredient>)recipe.m_7527_(), ingredientCounts, recipe.m_8043_(this.registryAccess), craftGuideSupplier);
        ++this.pushedSteps;
    }

    @Override
    public void addRecipe(ResourceLocation id, List<Ingredient> ingredients, List<Integer> ingredientCounts, ItemStack output, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier) {
        this.addRecipe(id, ingredients, ingredientCounts, List.of(output), craftGuideSupplier);
    }

    @Override
    public void addRecipe(ResourceLocation id, List<Ingredient> ingredients, List<Integer> ingredientCounts, List<ItemStack> output, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier) {
        this.addRecipeQueue.add(new AddRecipeData(id, ingredients, ingredientCounts, output, craftGuideSupplier, this.currentType, this.oneTime));
        ++this.pushedSteps;
    }

    @Override
    public void blockType(ResourceLocation type) {
        this.notToAddType.add(type);
    }

    @Override
    public void blockRecipe(ResourceLocation id) {
        this.notToAddRecipe.add(id);
    }

    @Override
    public void removeBlockedRecipe(ResourceLocation id) {
        this.notToAddRecipe.remove(id);
    }

    @Override
    public void removeBlockedType(ResourceLocation type) {
        this.notToAddType.remove(type);
    }

    @Override
    public List<CraftGuideData> getCraftGuides() {
        return this.craftGuides;
    }

    @Override
    public int getProcessedSteps() {
        return this.processedSteps;
    }

    @Override
    public int getPushedSteps() {
        return this.pushedSteps;
    }

    protected int _addRecipe(ResourceLocation id, List<Ingredient> ingredients, List<Integer> ingredientCounts, List<ItemStack> output, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier, ResourceLocation type, boolean isOneTime) {
        if (this.notToAddRecipe.contains(id) || this.notToAddType.contains(type)) {
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR_RECIPE, "recipe blocked %s", id);
            return 1;
        }
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR_RECIPE, "recipe add %s", id);
        ++this.processedSteps;
        int affectFactor = ingredients.size() + 1;
        if (RecipeIngredientCache.isCached(id) && RecipeIngredientCache.addCahcedRecipeToGraph(this, id, ingredients, ingredientCounts, output, craftGuideSupplier, type, isOneTime)) {
            return affectFactor;
        }
        RecipeIngredientCache.addRecipeCache(id, ingredients);
        RecipeIngredientCache.addCahcedRecipeToGraph(this, id, ingredients, ingredientCounts, output, craftGuideSupplier, type, isOneTime);
        return affectFactor += ingredients.size() + 1 + RecipeIngredientCache.getUncachedRecipeIngredient(id, ingredients, this) * 5;
    }

    @Override
    public void addRecipeWithIngredients(ResourceLocation id, List<Ingredient> ingredients, List<Integer> ingredientCounts, List<ItemStack> outputs, List<IngredientNode> ingredientNodes, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier, ResourceLocation type, boolean isOneTime) {
        CraftNode craftNode = this.getOrCreateCraftNode(id, ingredientCounts, ingredientNodes, craftGuideSupplier, type, isOneTime);
        for (IngredientNode ingredientNode : craftNode.independentIngredients) {
            ingredientNode.addEdge(craftNode, 1);
        }
        outputs.forEach(output -> craftNode.addEdge(this.getItemNodeOrCreate((ItemStack)output, false), 1));
    }

    @NotNull
    private CraftNode getOrCreateCraftNode(ResourceLocation id, List<Integer> ingredientCounts, List<IngredientNode> ingredientNodes, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier, ResourceLocation type, boolean isOneTime) {
        if (this.craftNodeMap.containsKey(id)) {
            CraftNode originalNode = this.craftNodeMap.get(id);
            if (originalNode.isRemoved) {
                originalNode.removeAllEdges(this);
                CraftNode craftNode = new CraftNode(id, originalNode.id, craftGuideSupplier, ingredientNodes, ingredientCounts, type, isOneTime);
                this.nodes.set(originalNode.id, craftNode);
                this.craftNodeMap.put(id, craftNode);
                return craftNode;
            }
            originalNode.removeAllEdges(this);
            originalNode.setNonRemoved();
            originalNode.addCraftGuideSupplier(craftGuideSupplier);
            return originalNode;
        }
        CraftNode craftNode = new CraftNode(id, this.nodes.size(), craftGuideSupplier, ingredientNodes, ingredientCounts, type, isOneTime);
        this.nodes.add(craftNode);
        this.craftNodeMap.put(id, craftNode);
        return craftNode;
    }

    @Override
    public boolean hasCachedIngredientNode(UUID ingredient) {
        return this.cachedIngredients.containsKey(ingredient);
    }

    @Override
    public boolean process() {
        if (!this.addRecipeQueue.isEmpty()) {
            this.processAddRecipe();
            return false;
        }
        if (!this.reversedQueue.isEmpty()) {
            this.processReversed();
            return false;
        }
        return this.processData();
    }

    public void processAddRecipe() {
        int c = 0;
        while (!this.addRecipeQueue.isEmpty() && c++ < 1000) {
            AddRecipeData addRecipeData = this.addRecipeQueue.poll();
            c += this._addRecipe(addRecipeData.id, addRecipeData.ingredients, addRecipeData.ingredientCounts, addRecipeData.output, addRecipeData.craftGuideSupplier, addRecipeData.currentType, addRecipeData.oneTime);
        }
    }

    public boolean processData() {
        int c = 0;
        while (!this.queue.isEmpty()) {
            if (c++ > 50) {
                return false;
            }
            Node node = this.queue.poll();
            ++this.processedSteps;
            node.inqueue = false;
            if (!node.related) continue;
            if (node instanceof ItemNode) {
                ItemNode itemNode = (ItemNode)node;
                if (!itemNode.isAvailable) {
                    itemNode.isAvailable = true;
                    itemNode.forEachEdge((toId, weight) -> {
                        Node to = this.getNode((int)toId);
                        this.addToQueueIfNotIn(to);
                    });
                    continue;
                }
            }
            if (node instanceof IngredientNode) {
                IngredientNode ingredientNode = (IngredientNode)node;
                ingredientNode.anyAvailable = true;
                ingredientNode.forEachEdge((toId, weight) -> {
                    Node to = this.getNode((int)toId);
                    if (to instanceof CraftNode) {
                        CraftNode craftNode = (CraftNode)to;
                        if (Config.generatePartial || craftNode.independentIngredients.stream().allMatch(t -> t.anyAvailable)) {
                            this.addToQueueIfNotIn(craftNode);
                        }
                    }
                });
                continue;
            }
            if (!(node instanceof CraftNode)) continue;
            CraftNode craftNode = (CraftNode)node;
            this.addNewCraft(craftNode);
            ++c;
            craftNode.forEachEdge((toId, weight) -> {
                Node to = this.getNode((int)toId);
                this.addToQueueIfNotIn(to);
            });
        }
        return true;
    }

    public boolean processReversed() {
        int c = 0;
        while (!this.reversedQueue.isEmpty()) {
            if (c++ >= 500) {
                return false;
            }
            Node node = this.reversedQueue.poll();
            node.related = true;
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR, "%s marked related", node);
            ++this.processedSteps;
            node.forEachRev((toId, weight) -> {
                Node to = this.getNode((int)toId);
                if (!to.related) {
                    to.related = true;
                    this.reversedQueue.add(to);
                    ++this.pushedSteps;
                }
            });
        }
        return true;
    }

    protected void addToQueueIfNotIn(Node node) {
        if (!node.inqueue) {
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR, "%s marked available", node);
            node.inqueue = true;
            this.queue.add(node);
            ++this.pushedSteps;
        }
    }

    public void addNewCraft(CraftNode craftNode) {
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.GENERATOR, "%s generated", craftNode);
        ArrayList<Integer> selections = new ArrayList<Integer>();
        for (int i = 0; i < craftNode.independentIngredients.size(); ++i) {
            selections.add(0);
        }
        this.addNewCraft(craftNode, 0, selections);
    }

    public void addNewCraft(CraftNode craftNode, int step, List<Integer> ingredientSelections) {
        block7: {
            block6: {
                if (step < craftNode.independentIngredients.size()) break block6;
                if (craftNode.used.contains(ingredientSelections)) break block7;
                craftNode.used.add(ingredientSelections);
                HashMap<Integer, ItemStack> ingredientId2ItemStack = new HashMap<Integer, ItemStack>();
                for (int i = 0; i < craftNode.independentIngredients.size(); ++i) {
                    IngredientNode ingredientNode = craftNode.independentIngredients.get(i);
                    if (ingredientNode.possibleItems.isEmpty()) {
                        ingredientId2ItemStack.put(ingredientNode.id, ItemStack.f_41583_);
                        continue;
                    }
                    ingredientId2ItemStack.put(ingredientNode.id, ingredientNode.possibleItems.get(ingredientSelections.get(i)));
                }
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i < craftNode.ingredientNodes.size(); ++i) {
                    ItemStack itemStack = (ItemStack)ingredientId2ItemStack.get(craftNode.ingredientNodes.get((int)i).id);
                    items.add(itemStack.m_255036_(craftNode.ingredientCounts.get(i).intValue()));
                }
                for (Function<List<ItemStack>, CraftGuideData> f : craftNode.craftGuideSupplier) {
                    CraftGuideData apply = f.apply(items);
                    if (apply == null) continue;
                    this.debugContext.log(CraftingDebugContext.TYPE.GENERATOR_GUIDE, "Craft guide added %s", apply);
                    this.craftGuides.add(apply);
                }
                break block7;
            }
            if (craftNode.independentIngredients.get((int)step).possibleItems.isEmpty()) {
                this.addNewCraft(craftNode, step + 1, ingredientSelections);
                return;
            }
            for (int i = 0; i < craftNode.independentIngredients.get((int)step).possibleItems.size(); ++i) {
                if (!craftNode.independentIngredients.get((int)step).possibleItemNodes.get((int)i).isAvailable) continue;
                ingredientSelections.set(step, i);
                this.addNewCraft(craftNode, step + 1, ingredientSelections);
            }
        }
    }

    @Override
    public void clearStates() {
        for (Node node : this.nodes) {
            node.inqueue = false;
            node.related = false;
            if (node instanceof ItemNode) {
                ItemNode in = (ItemNode)node;
                in.isAvailable = false;
                continue;
            }
            if (node instanceof IngredientNode) {
                IngredientNode in = (IngredientNode)node;
                in.anyAvailable = false;
                continue;
            }
            if (!(node instanceof CraftNode)) continue;
            CraftNode cn = (CraftNode)node;
            cn.used.clear();
        }
        this.addRecipeQueue.clear();
        this.queue.clear();
        this.reversedQueue.clear();
        this.notToAddRecipe.clear();
        this.notToAddType.clear();
        this.craftGuides.clear();
    }

    @Override
    public void invalidAllCraftWithType(ResourceLocation type) {
        for (Node node : this.nodes) {
            if (!(node instanceof CraftNode)) continue;
            CraftNode cn = (CraftNode)node;
            if (!cn.type.equals((Object)type)) continue;
            cn.removeAllEdges(this);
        }
    }

    protected record AddRecipeData(ResourceLocation id, List<Ingredient> ingredients, List<Integer> ingredientCounts, List<ItemStack> output, Function<List<ItemStack>, @Nullable CraftGuideData> craftGuideSupplier, ResourceLocation currentType, boolean oneTime) {
    }
}

