/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.mekanism;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.integration.mekanism.MekanismIntegration;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public abstract class GeneratorMek<T extends MekanismRecipe, C extends IInputRecipeCache>
implements IAutoCraftGuideGenerator {
    protected abstract MekanismRecipeType<T, C> getRecipeType();

    @Override
    @NotNull
    public ResourceLocation getType() {
        return this.getRecipeType().getRegistryName();
    }

    abstract List<Ingredient> getRecipeIngredients(T var1, RecipeManager var2, Map<ResourceLocation, List<BlockPos>> var3);

    public List<Integer> getIngredientCounts(T recipe, List<Ingredient> ingredients) {
        return ingredients.stream().map(t -> Arrays.stream(t.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(1)).toList();
    }

    public List<ItemStack> getRecipeOutputs(T recipe, RegistryAccess registryAccess) {
        return List.of(recipe.m_8043_(registryAccess));
    }

    @Nullable
    protected Direction getTypeDirection(TileEntityConfigurableMachine machine, List<DataType> dataTypes) {
        ConfigInfo config = machine.getConfig().getConfig(TransmissionType.ITEM);
        if (config == null) {
            return null;
        }
        for (DataType dataType : dataTypes) {
            Set sidesForData = config.getSidesForData(dataType);
            if (sidesForData.isEmpty()) continue;
            return (Direction)sidesForData.iterator().next();
        }
        return null;
    }

    protected abstract boolean addSteps(BlockPos var1, TileEntityConfigurableMachine var2, T var3, List<ItemStack> var4, List<ItemStack> var5, List<CraftGuideStepData> var6);

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityConfigurableMachine) {
            TileEntityConfigurableMachine machine = (TileEntityConfigurableMachine)blockEntity;
            level.m_7465_().m_44013_(this.getRecipeType()).forEach(recipe -> this.generate(recipe, machine, level, pos, graph, recognizedTypePositions, posFilter));
        }
    }

    public void generate(T recipe, TileEntityConfigurableMachine machine, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions, StorageAccessUtil.Filter posFilter) {
        List<Ingredient> ingredient = this.getRecipeIngredients(recipe, level.m_7465_(), recognizedTypePositions);
        List<Integer> counts = this.getIngredientCounts(recipe, ingredient);
        List<ItemStack> outputs = this.getRecipeOutputs(recipe, level.m_9598_());
        if (outputs.isEmpty() || !posFilter.isAvailable(outputs.get(0))) {
            return;
        }
        this.generateForIOR(recipe, machine, pos, graph, ingredient, counts, outputs);
    }

    protected void generateForIOR(T recipe, TileEntityConfigurableMachine machine, BlockPos pos, ICachableGeneratorGraph graph, List<Ingredient> ingredient, List<Integer> counts, List<ItemStack> outputs) {
        List<Integer> copiedCounts = counts.stream().map(count -> count * this.getRecipeMultiplier((BlockEntity)machine, recipe)).toList();
        List<ItemStack> copiedOutputs = outputs.stream().map(output -> output.m_255036_(output.m_41613_() * this.getRecipeMultiplier((BlockEntity)machine, recipe))).toList();
        graph.addRecipe(recipe.m_6423_(), ingredient, copiedCounts, copiedOutputs, items -> {
            ArrayList<CraftGuideStepData> step = new ArrayList<CraftGuideStepData>();
            if (this.addSteps(pos, machine, recipe, (List<ItemStack>)items, copiedOutputs, (List<CraftGuideStepData>)step)) {
                return new CraftGuideData(step, CommonType.TYPE);
            }
            return null;
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
    }

    @Override
    public boolean positionalAvailable(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        TileEntityMekanism machine;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityMekanism && !MekanismIntegration.isAccessibleByMaid(machine = (TileEntityMekanism)blockEntity, maid)) {
            return false;
        }
        return IAutoCraftGuideGenerator.super.positionalAvailable(level, maid, pos, pathFinding);
    }

    protected int getRecipeMultiplier(BlockEntity machine, T recipe) {
        return 1;
    }

    protected int getFactoryParallel(BlockEntity machine) {
        if (machine instanceof TileEntityFactory) {
            TileEntityFactory factory = (TileEntityFactory)machine;
            return factory.tier.processes;
        }
        return 1;
    }
}

