/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class InventoryItem
implements INBTSerializable<CompoundTag> {
    public ItemStack itemStack;
    public int totalCount;
    public List<PositionCount> posAndSlot;

    public InventoryItem(ItemStack itemStack, int totalCount, List<PositionCount> posAndSlot) {
        this.itemStack = itemStack.m_255036_(1);
        this.totalCount = totalCount;
        this.posAndSlot = posAndSlot;
    }

    public InventoryItem(ItemStack itemStack, int totalCount) {
        this.itemStack = itemStack.m_255036_(1);
        this.totalCount = totalCount;
        this.posAndSlot = new ArrayList<PositionCount>();
    }

    public void addCount(Target pos, int second) {
        this.posAndSlot.add(new PositionCount(pos, second, false));
        this.totalCount += second;
    }

    public void addCraftGuidePos(Target pos) {
        this.posAndSlot.add(new PositionCount(pos, 0, true));
    }

    public Pair<ItemStack, Integer> toPair() {
        return new Pair((Object)this.itemStack, (Object)this.totalCount);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("itemStack", (Tag)this.itemStack.serializeNBT());
        tag.m_128405_("totalCount", this.totalCount);
        ListTag list = new ListTag();
        for (int i = 0; i < this.posAndSlot.size(); ++i) {
            CompoundTag posAndSlotTag = new CompoundTag();
            posAndSlotTag.m_128365_("pos", (Tag)this.posAndSlot.get(i).pos().toNbt());
            posAndSlotTag.m_128405_("count", this.posAndSlot.get(i).count());
            posAndSlotTag.m_128379_("isCraftGuide", this.posAndSlot.get(i).isCraftGuide());
            list.add((Object)posAndSlotTag);
        }
        tag.m_128365_("posCount", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.itemStack = ItemStackUtil.parseStack(nbt.m_128469_("itemStack"));
        this.totalCount = nbt.m_128451_("totalCount");
        ListTag list = nbt.m_128437_("posCount", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            this.posAndSlot.add(new PositionCount(Target.fromNbt(tmp.m_128469_("pos")), tmp.m_128451_("count"), tmp.m_128471_("isCraftGuide")));
        }
    }

    public static InventoryItem fromNbt(CompoundTag tag) {
        InventoryItem inventoryItem = new InventoryItem(ItemStack.f_41583_, 0);
        inventoryItem.deserializeNBT(tag);
        return inventoryItem;
    }

    public record PositionCount(Target pos, int count, boolean isCraftGuide) {
    }
}

