/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.craft.type.ICraftType;
import studio.fantasyit.maid_storage_manager.items.render.CustomItemRenderer;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class CraftGuide
extends Item
implements MenuProvider {
    public static final String TAG_RESULT = "result";
    public static final String TAG_SELECTING = "selecting";
    public static final String TAG_STEPS = "steps";
    public static final String TAG_OP_STORAGE = "storage";
    public static final String TAG_OP_ACTION = "action";
    public static final String TAG_ITEMS_ITEM = "item";
    public static final String TAG_ITEMS_COUNT = "requested";
    public static final String TAG_OP_MATCH_TAG = "match_tag";
    public static final String TAG_TYPE = "type";
    public static final String TAG_OP_OPTIONAL = "optional";
    public static final String TAG_OP_INPUT = "input";
    public static final String TAG_OP_OUTPUT = "output";
    public static final String TAG_OP_EXTRA = "extra";
    public static final String TAG_SPECIAL_OP = "special";
    public static final String TAG_MARK_MERGEABLE = "mergeable";
    public static final String TAG_MARK_NO_OCCUPY = "no_occupy";

    public static Component getStatusMessage(ItemStack stack) {
        int selectId = CraftGuide.getSelectId(stack);
        SpecialOP specialOP = CraftGuide.getSpecialOP(stack);
        CraftGuideRenderData data = CraftGuideRenderData.fromItemStack(stack);
        MutableComponent result = selectId == data.stepBindings.size() ? Component.m_237115_((String)("interaction.select_step_new." + specialOP.name().toLowerCase())) : Component.m_237110_((String)("interaction.select_step_index." + specialOP.name().toLowerCase()), (Object[])new Object[]{selectId + 1});
        return switch (specialOP) {
            default -> throw new IncompatibleClassChangeError();
            case SpecialOP.NONE -> result;
            case SpecialOP.COPY -> result.m_6881_().m_130940_(ChatFormatting.YELLOW);
            case SpecialOP.REPLACE -> result.m_6881_().m_130940_(ChatFormatting.RED);
        };
    }

    public CraftGuide() {
        super(new Item.Properties().m_41487_(1));
    }

    public static boolean matchNbt(ItemStack mainHandItem, String targ) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) {
            return false;
        }
        if (!mainHandItem.m_41782_()) {
            return true;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        if (!tag.m_128441_(targ)) {
            return true;
        }
        if (!tag.m_128469_(targ).m_128441_(TAG_OP_MATCH_TAG)) {
            return true;
        }
        return tag.m_128469_(targ).m_128471_(TAG_OP_MATCH_TAG);
    }

    public static int getSelectId(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return 0;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        if (!tag.m_128441_(TAG_SELECTING)) {
            return 0;
        }
        return tag.m_128451_(TAG_SELECTING);
    }

    public static void setSelectId(ItemStack itemInHand, int value) {
        CompoundTag tag = itemInHand.m_41784_();
        tag.m_128405_(TAG_SELECTING, value);
        itemInHand.m_41751_(tag);
    }

    public static void setSpecialOP(ItemStack itemInHand, SpecialOP value) {
        CompoundTag tag = itemInHand.m_41784_();
        tag.m_128405_(TAG_SPECIAL_OP, value.ordinal());
        itemInHand.m_41751_(tag);
    }

    public static SpecialOP getSpecialOP(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return SpecialOP.NONE;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        if (!tag.m_128441_(TAG_SPECIAL_OP)) {
            return SpecialOP.NONE;
        }
        return SpecialOP.values()[tag.m_128451_(TAG_SPECIAL_OP)];
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand p_41434_) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!CraftGuideData.fromItemStack(player.m_21120_(p_41434_)).getSteps().isEmpty()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> {});
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"interaction.no_step"));
            }
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(p_41434_));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
    }

    public static void rollSpecial(ItemStack itemInHand, ServerPlayer serverPlayer, int value) {
        SpecialOP specialOP = CraftGuide.getSpecialOP(itemInHand);
        specialOP = SpecialOP.values()[(specialOP.ordinal() + value + SpecialOP.values().length) % SpecialOP.values().length];
        CraftGuide.setSpecialOP(itemInHand, specialOP);
    }

    public static void rollMode(ItemStack itemInHand, ServerPlayer serverPlayer, int value) {
        CraftGuideData craftGuideData = CraftGuideData.fromItemStack(itemInHand);
        int selectId = CraftGuide.getSelectId(itemInHand);
        selectId = (selectId + value + craftGuideData.getSteps().size() + 1) % (craftGuideData.getSteps().size() + 1);
        CraftGuide.setSelectId(itemInHand, selectId);
        CraftGuideRenderData.recalculateItemStack(itemInHand);
    }

    public static void rollMode(ItemStack itemInHand, ServerPlayer serverPlayer) {
        CraftGuide.rollMode(itemInHand, serverPlayer, 1);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player;
        if (!context.m_43725_().f_46443_ && (player = context.m_43723_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.m_6144_()) {
                return InteractionResult.PASS;
            }
            ItemStack itemInHand = context.m_43722_();
            CraftGuideData craftGuideData = CraftGuideData.fromItemStack(itemInHand);
            SpecialOP specialOP = CraftGuide.getSpecialOP(itemInHand);
            @NotNull InteractionResult result = switch (specialOP) {
                default -> throw new IncompatibleClassChangeError();
                case SpecialOP.NONE -> this.operateNormal(context, serverPlayer, craftGuideData, itemInHand);
                case SpecialOP.COPY -> this.operateCopy(context, serverPlayer, craftGuideData, itemInHand);
                case SpecialOP.REPLACE -> this.operateReplace(context, serverPlayer, craftGuideData, itemInHand);
            };
            craftGuideData.saveToItemStack(itemInHand);
            CraftGuideRenderData.recalculateItemStack(itemInHand);
            return result;
        }
        if (Objects.requireNonNull(context.m_43723_()).m_6144_()) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    private InteractionResult operateReplace(@NotNull UseOnContext context, ServerPlayer serverPlayer, CraftGuideData craftGuideData, ItemStack itemInHand) {
        if (craftGuideData.getSteps().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (craftGuideData.getSteps().size() == craftGuideData.selecting.intValue()) {
            craftGuideData.getSteps().forEach(t -> {
                t.storage = new Target(t.storage.getType(), context.m_8083_(), t.storage.getSide());
            });
        } else {
            CraftGuideStepData step = craftGuideData.getStepByIdx(craftGuideData.selecting);
            step.storage = new Target(step.storage.getType(), context.m_8083_(), step.storage.getSide());
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    private InteractionResult operateCopy(@NotNull UseOnContext context, ServerPlayer serverPlayer, CraftGuideData craftGuideData, ItemStack itemInHand) {
        if (craftGuideData.getSteps().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (craftGuideData.getSteps().size() == craftGuideData.selecting.intValue()) {
            new ArrayList<CraftGuideStepData>(craftGuideData.getSteps()).stream().map(t -> CraftGuideStepData.fromCompound(t.toCompound())).forEach(t -> {
                t.storage = new Target(t.storage.getType(), context.m_8083_(), t.storage.getSide());
                craftGuideData.steps.add((CraftGuideStepData)t);
            });
        } else {
            CraftGuideStepData newStep = CraftGuideStepData.fromCompound(craftGuideData.getSteps().get(craftGuideData.selecting).toCompound());
            newStep.storage = new Target(newStep.storage.getType(), context.m_8083_(), newStep.storage.getSide());
            craftGuideData.steps.add(newStep);
        }
        craftGuideData.selecting = craftGuideData.steps.size() - 1;
        return InteractionResult.SUCCESS;
    }

    @NotNull
    private InteractionResult operateNormal(@NotNull UseOnContext context, ServerPlayer serverPlayer, CraftGuideData craftGuideData, ItemStack itemInHand) {
        Target target;
        int selecting = craftGuideData.selecting;
        ResourceLocation specialType = CommonType.TYPE;
        if (craftGuideData.getSteps().size() == 1 && craftGuideData.selecting == 0 && !craftGuideData.getSteps().get((int)0).storage.getPos().equals((Object)context.m_8083_())) {
            craftGuideData.getSteps().remove(0);
            craftGuideData.type = CommonType.TYPE;
        }
        if (craftGuideData.selecting == 0 && craftGuideData.getSteps().size() == 0 && craftGuideData.getType().equals((Object)CommonType.TYPE)) {
            specialType = CraftManager.getInstance().getTargetType((ServerLevel)context.m_43725_(), context.m_8083_(), context.m_43719_());
        }
        if (specialType == null) {
            specialType = CommonType.TYPE;
        }
        if ((target = MaidStorage.getInstance().isValidTarget((ServerLevel)context.m_43725_(), (LivingEntity)context.m_43723_(), context.m_8083_(), context.m_43719_())) == null) {
            target = Target.virtual(context.m_8083_(), context.m_43719_());
        }
        if (specialType == CommonType.TYPE) {
            if (craftGuideData.getSteps().size() <= selecting) {
                if (!craftGuideData.getSteps().isEmpty() && !craftGuideData.getSteps().get((int)0).actionType.canBeCommon()) {
                    craftGuideData.getSteps().get((int)0).actionType = CraftManager.getInstance().getDefaultAction();
                    craftGuideData.getSteps().get((int)0).action = craftGuideData.getSteps().get((int)0).actionType.type();
                }
                craftGuideData.getSteps().add(CraftGuideStepData.createFromTypeStorage(target.withoutSide(), CraftManager.getInstance().getDefaultAction().type()));
            } else {
                CraftGuideStepData craftGuideStepData = craftGuideData.getSteps().get(selecting);
                if (!craftGuideStepData.actionType.canBeCommon()) {
                    craftGuideStepData.actionType = CraftManager.getInstance().getDefaultAction();
                    craftGuideStepData.action = craftGuideStepData.actionType.type();
                    craftGuideStepData.storage = target.withoutSide();
                } else {
                    Target existingTarget = craftGuideStepData.getStorage();
                    if (existingTarget.equals(target)) {
                        craftGuideData.getSteps().remove(selecting);
                    } else {
                        craftGuideStepData.storage = existingTarget.withoutSide().equals(target.withoutSide()) ? target : target.withoutSide();
                    }
                }
            }
            craftGuideData.type = specialType;
        } else {
            List<CraftGuideStepData> steps = craftGuideData.getSteps();
            steps.clear();
            steps.add(CraftGuideStepData.createFromTypeStorage(target.withoutSide(), specialType));
            craftGuideData.type = specialType;
        }
        if (craftGuideData.type != CommonType.TYPE) {
            CraftManager.getInstance().getType(craftGuideData.type).onTypeUsing(serverPlayer, itemInHand, craftGuideData);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        CraftGuideRenderData data = CraftGuideRenderData.fromItemStack(itemStack);
        toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.craft_guide.input.title", (Object[])new Object[]{data.inputs.size()}).m_130940_(ChatFormatting.GRAY));
        for (ItemStack input : data.inputs) {
            toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.craft_guide.input.item", (Object[])new Object[]{input.m_41786_(), input.m_41613_()}).m_130940_(ChatFormatting.GRAY));
        }
        toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.craft_guide.output.title", (Object[])new Object[]{data.outputs.size()}).m_130940_(ChatFormatting.GRAY));
        for (ItemStack output : data.outputs) {
            toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.craft_guide.output.item", (Object[])new Object[]{output.m_41786_(), output.m_41613_()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        CraftGuideData craftGuideData = CraftGuideData.fromItemStack(p_39956_.m_21120_(InteractionHand.MAIN_HAND));
        if (craftGuideData.getType() == null) {
            return null;
        }
        ICraftType type = CraftManager.getInstance().getType(craftGuideData.getType());
        if (type == null) {
            return null;
        }
        return type.createGui(p_39954_, p_39956_.m_9236_(), p_39956_, craftGuideData);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return CustomItemRenderer.getInstance();
            }
        });
    }

    public static enum SpecialOP {
        NONE,
        COPY,
        REPLACE;

    }
}

