/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.menu.LogisticsGuideMenu;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class LogisticsGuide
extends MaidInteractItem
implements MenuProvider,
IMaidBauble {
    public static final String TAG_ITEM = "item";
    public static final String TAG_INPUT = "input";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_SELECTING = "selecting";
    public static final String TAG_SINGLE_MODE = "single_mode";

    public LogisticsGuide() {
        super(new Item.Properties().m_41487_(1));
    }

    public static Component getTip(ItemStack itemInHand) {
        int selectId = LogisticsGuide.getSelectId(itemInHand);
        if (selectId == 0) {
            return Component.m_237115_((String)"interaction.select_extract");
        }
        return Component.m_237115_((String)"interaction.select_store");
    }

    public static int getSelectId(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return 0;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        if (!tag.m_128441_(TAG_SELECTING)) {
            return 0;
        }
        return tag.m_128451_(TAG_SELECTING);
    }

    public static void setSelectId(ItemStack itemInHand, int value) {
        CompoundTag tag = itemInHand.m_41784_();
        tag.m_128405_(TAG_SELECTING, value);
        itemInHand.m_41751_(tag);
    }

    public static void rollMode(ItemStack itemInHand, ServerPlayer serverPlayer, int value) {
        int selectId = LogisticsGuide.getSelectId(itemInHand);
        selectId = selectId == 0 ? 1 : 0;
        LogisticsGuide.setSelectId(itemInHand, selectId);
    }

    public static void rollMode(ItemStack itemInHand, ServerPlayer serverPlayer) {
        LogisticsGuide.rollMode(itemInHand, serverPlayer, 1);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand p_41434_) {
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
        }
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> {});
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(p_41434_));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
    }

    public static CraftGuideData getCraftGuideData(ItemStack itemInHand) {
        ItemStack craftGuideItemStack = LogisticsGuide.getCraftGuideItemStack(itemInHand);
        if (craftGuideItemStack.m_41619_()) {
            return null;
        }
        return CraftGuideData.fromItemStack(craftGuideItemStack);
    }

    public static ItemStack getCraftGuideItemStack(ItemStack itemInHand) {
        ItemStack item = LogisticsGuide.getItemStack(itemInHand);
        return item.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) ? item : ItemStack.f_41583_;
    }

    public static ItemStack getFilterItemStack(ItemStack itemInHand) {
        ItemStack item = LogisticsGuide.getItemStack(itemInHand);
        return item.m_150930_((Item)ItemRegistry.FILTER_LIST.get()) ? item : ItemStack.f_41583_;
    }

    public static ItemStack getItemStack(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        if (!tag.m_128441_(TAG_ITEM)) {
            return ItemStack.f_41583_;
        }
        return ItemStackUtil.parseStack(tag.m_128469_(TAG_ITEM));
    }

    @Nullable
    public static Target getInput(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        if (!tag.m_128441_(TAG_INPUT)) {
            return null;
        }
        return Target.fromNbt(tag.m_128469_(TAG_INPUT));
    }

    @Nullable
    public static Target getOutput(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        if (!tag.m_128441_(TAG_OUTPUT)) {
            return null;
        }
        return Target.fromNbt(tag.m_128469_(TAG_OUTPUT));
    }

    public static int getWorkCount(ItemStack itemInHand) {
        if (!itemInHand.m_41782_()) {
            return 0;
        }
        CompoundTag tag = Objects.requireNonNull(itemInHand.m_41783_());
        return tag.m_128471_(TAG_SINGLE_MODE) ? 1 : 64;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player;
        if (!context.m_43725_().f_46443_ && (player = context.m_43723_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.m_6144_()) {
                return InteractionResult.PASS;
            }
            String selectingTag = LogisticsGuide.getSelectId(context.m_43722_()) == 0 ? TAG_INPUT : TAG_OUTPUT;
            BlockPos clickedPos = context.m_8083_();
            Target validTarget = MaidStorage.getInstance().isValidTarget((ServerLevel)context.m_43725_(), (LivingEntity)serverPlayer, clickedPos);
            if (validTarget != null) {
                ItemStack item = serverPlayer.m_21205_();
                CompoundTag tag = item.m_41784_();
                if (tag.m_128441_(selectingTag)) {
                    Target storage = Target.fromNbt(tag.m_128469_(selectingTag));
                    if (storage.getPos().equals((Object)clickedPos) && storage.getSide().isPresent() && storage.getSide().get() == context.m_43719_()) {
                        tag.m_128473_(selectingTag);
                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"interaction.clear_storage"));
                    } else {
                        if (storage.pos.equals((Object)clickedPos)) {
                            storage.side = context.m_43719_();
                        } else {
                            storage.pos = clickedPos;
                            storage.side = null;
                        }
                        serverPlayer.m_213846_((Component)Component.m_237110_((String)"interaction.bind_storage", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
                        tag.m_128365_(selectingTag, (Tag)storage.toNbt());
                    }
                } else {
                    tag.m_128365_(selectingTag, (Tag)validTarget.toNbt());
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"interaction.bind_storage", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
                }
                item.m_41751_(tag);
            }
            return InteractionResult.CONSUME;
        }
        if (Objects.requireNonNull(context.m_43723_()).m_6144_()) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new LogisticsGuideMenu(p_39954_, p_39956_);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        ItemStack itemStack1;
        Target output;
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.logistics_guide.desc").m_130940_(ChatFormatting.GRAY));
        if (!itemStack.m_41782_()) {
            return;
        }
        @Nullable Target input = LogisticsGuide.getInput(itemStack);
        if (input != null) {
            toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.logistics_guide.input", (Object[])new Object[]{input.pos.m_123341_(), input.pos.m_123342_(), input.pos.m_123343_()}));
        }
        if ((output = LogisticsGuide.getOutput(itemStack)) != null) {
            toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.logistics_guide.output", (Object[])new Object[]{output.pos.m_123341_(), output.pos.m_123342_(), output.pos.m_123343_()}));
        }
        if ((itemStack1 = LogisticsGuide.getItemStack(itemStack)).m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.logistics_guide.craft_guide").m_130940_(ChatFormatting.YELLOW));
        } else if (itemStack1.m_150930_((Item)ItemRegistry.FILTER_LIST.get())) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.logistics_guide.filter").m_130940_(ChatFormatting.YELLOW));
        }
    }
}

