/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.place;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IFilterable;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInsertableContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import studio.fantasyit.maid_storage_manager.util.ViewedInventoryUtil;

public class PlaceBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    private IStorageContext context = null;
    Target target = null;
    int count = 0;
    private boolean changed;

    public PlaceBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.PLACE) {
            return false;
        }
        if (!super.m_6114_(worldIn, (LivingEntity)owner)) {
            return false;
        }
        if (!MemoryUtil.getPlacingInv(owner).hasTarget()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(owner);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (Conditions.isWaitingForReturn(maid)) {
            return false;
        }
        if (Conditions.isNothingToPlace(maid)) {
            return false;
        }
        if (this.count >= maid.getAvailableInv(false).getSlots()) {
            return false;
        }
        return this.context != null && !this.context.isDone();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        if (!MemoryUtil.getPlacingInv(maid).hasTarget()) {
            return;
        }
        MemoryUtil.setWorking(maid, true);
        this.target = MemoryUtil.getPlacingInv(maid).getTarget();
        this.context = MaidStorage.getInstance().getStorage(this.target.getType()).onStartPlace(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.count = 0;
        this.changed = false;
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        super.m_6725_(p_22551_, (LivingEntity)maid, p_22553_);
        if (!this.breath.breathTick(maid)) {
            return;
        }
        CombinedInvWrapper inv = maid.getAvailableInv(false);
        for (int _i = 0; _i < inv.getSlots() / 3; ++_i) {
            IFilterable iFilterable;
            if (this.count >= inv.getSlots()) {
                return;
            }
            @NotNull ItemStack item = inv.getStackInSlot(this.count);
            int oCount = item.m_41613_();
            IStorageContext iStorageContext = this.context;
            if (iStorageContext instanceof IFilterable && !(iFilterable = (IFilterable)((Object)iStorageContext)).isAvailable(item)) {
                ++this.count;
                continue;
            }
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageInsertableContext) {
                IStorageInsertableContext isic = (IStorageInsertableContext)iStorageContext;
                List<ItemStack> arrangeItems = MemoryUtil.getPlacingInv(maid).getArrangeItems();
                if (arrangeItems.isEmpty() || arrangeItems.stream().anyMatch(i -> ItemStack.m_41656_((ItemStack)i, (ItemStack)item))) {
                    if (item.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
                        if (RequestListItem.isIgnored(item)) {
                            CompoundTag tag = item.m_41784_();
                            tag.m_128379_("ignore_task", true);
                            item.m_41751_(tag);
                            ItemStack insert = isic.insert(item);
                            ViewedInventoryUtil.ambitiousAddItemAndSync(maid, p_22551_, this.target, item.m_255036_(oCount - insert.m_41613_()));
                            inv.setStackInSlot(this.count, insert);
                        }
                    } else {
                        ItemStack insert = isic.insert(item);
                        ViewedInventoryUtil.ambitiousAddItemAndSync(maid, p_22551_, this.target, item.m_255036_(oCount - insert.m_41613_()));
                        inv.setStackInSlot(this.count, insert);
                    }
                }
            }
            if (inv.getStackInSlot(this.count).m_41613_() != oCount) {
                this.changed = true;
            }
            ++this.count;
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        MemoryUtil.setWorking(maid, false);
        if (this.context != null) {
            this.context.finish();
            MemoryUtil.getPlacingInv(maid).clearTarget();
            if (!this.changed) {
                MemoryUtil.getPlacingInv(maid).addVisitedPos(this.target);
            } else {
                MemoryUtil.getPlacingInv(maid).anySuccess();
            }
            MemoryUtil.getPlacingInv(maid).clearArrangeItems();
            StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getPlacingInv(maid).addVisitedPos(this.target.sameType((BlockPos)pos, null)));
        }
        if (!this.changed && ((StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault())).suppressStrategy() != StorageManagerConfigData.SuppressStrategy.AFTER_ALL) {
            MemoryUtil.getPlacingInv(maid).addSuppressedPos(this.target);
            DebugData.sendDebug("[PLACE]Suppress set at %s", this.target);
        }
        MemoryUtil.clearTarget(maid);
        MemoryUtil.getCrafting(maid).tryStartIfHasPlan();
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

