/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.menu.container.NoPlaceFilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.SimpleSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonStepDataContainer;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CommonCraftMenu
extends AbstractContainerMenu
implements ISaveFilter,
ICraftGuiPacketReceiver {
    Player player;
    ItemStack target;
    CraftGuideData craftGuideData;
    public int selectedIndex = -1;
    public CommonStepDataContainer currentEditingItems = new CommonStepDataContainer(this);
    public FilterSlot[] filterSlots = new FilterSlot[4];
    public NoPlaceFilterSlot blockIndicator;
    public List<NoPlaceFilterSlot> blockIndicatorForSteps;
    public boolean isHandRelated = false;

    public CommonCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_COMMON.get(), p_38852_);
        this.player = player;
        this.target = player.m_21205_();
        this.craftGuideData = CraftGuideData.fromItemStack(this.target);
        this.addFilterSlots();
        this.addPlayerSlots();
        this.addSpecialSlots();
    }

    private void addFilterSlots() {
        int sx = 113;
        int sy = 24;
        int dx = 20;
        int dy = 18;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                FilterSlot slot;
                this.filterSlots[x * 2 + y] = slot = (FilterSlot)this.m_38897_(new FilterSlot(this.currentEditingItems, x * 2 + y, sx + x * dx, sy + y * dy));
                slot.setActive(false);
            }
        }
        this.blockIndicator = (NoPlaceFilterSlot)this.m_38897_(new NoPlaceFilterSlot(130, 70, ItemStack.f_41583_, 0));
    }

    private void addPlayerSlots() {
        int i;
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 164;
        int startX = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), 9 + i * 9 + j, 8 + j * 18, 164 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), i, 8 + i * 18, 222));
        }
    }

    private void addSpecialSlots() {
        this.blockIndicatorForSteps = new ArrayList<NoPlaceFilterSlot>();
        for (CraftGuideStepData stepData : this.craftGuideData.steps) {
            ItemStack itemStack = this.player.m_9236_().m_8055_(stepData.storage.pos).m_60734_().m_5456_().m_7968_();
            Slot slot = this.m_38897_(new NoPlaceFilterSlot(0, 0, itemStack, 0));
            this.blockIndicatorForSteps.add((NoPlaceFilterSlot)slot);
        }
        int i = 0;
        while (i < this.currentEditingItems.m_6643_()) {
            int finalI = i++;
            this.m_38895_(new SimpleSlot(t -> this.currentEditingItems.setCount(finalI, (int)t), () -> this.currentEditingItems.getCount(finalI)));
        }
        this.m_38895_(new SimpleSlot(t -> {
            this.isHandRelated = t == 1;
        }, () -> this.isHandRelated ? 1 : 0));
        this.m_38895_(new SimpleSlot(t -> this.craftGuideData.isNoOccupy(t != 0), () -> this.craftGuideData.isNoOccupy() ? 1 : 0));
        this.m_38895_(new SimpleSlot(t -> this.craftGuideData.isMergeable(t != 0), () -> this.craftGuideData.isMergeable() ? 1 : 0));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && (slot = this.m_38853_(slotId)) instanceof NoPlaceFilterSlot) {
            NoPlaceFilterSlot fs = (NoPlaceFilterSlot)slot;
            fs.m_5852_(ItemStack.f_41583_);
            this.save();
            return;
        }
        if (slotId >= 0 && (slot = this.m_38853_(slotId)) instanceof FilterSlot) {
            FilterSlot fs = (FilterSlot)slot;
            if (fs.f_40218_ == this.currentEditingItems) {
                ItemStack insert;
                int slot2 = fs.m_150661_();
                if (clickTypeIn == ClickType.THROW) {
                    return;
                }
                ItemStack held = this.m_142621_();
                if (clickTypeIn == ClickType.CLONE) {
                    if (!player.m_7500_()) return;
                    if (!held.m_41619_()) return;
                    ItemStack stackInSlot = this.currentEditingItems.m_8020_(slot2).m_41777_();
                    stackInSlot.m_41764_(stackInSlot.m_41741_());
                    this.m_142503_(stackInSlot);
                    this.save();
                    return;
                }
                if (held.m_41619_()) {
                    insert = ItemStack.f_41583_;
                } else {
                    insert = held.m_41777_();
                    insert.m_41764_(1);
                }
                this.currentEditingItems.setItemNoTrigger(slot2, insert);
                this.currentEditingItems.setCount(slot2, 1);
                this.m_38853_(slotId).m_6654_();
                this.save();
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_6199_(Container p_38868_) {
        super.m_6199_(p_38868_);
        this.save();
    }

    @NotNull
    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        Slot slot = this.m_38853_(p_38942_);
        if (slot.m_6657_()) {
            if (slot instanceof FilterSlot) {
                FilterSlot fs = (FilterSlot)slot;
                fs.m_5852_(ItemStack.f_41583_);
            } else {
                boolean found = false;
                Object target = null;
                int toPlace = -1;
                for (int j = 0; j < this.currentEditingItems.m_6643_(); ++j) {
                    if (this.currentEditingItems.m_8020_(j).m_41619_()) {
                        if (toPlace != -1) continue;
                        toPlace = j;
                        continue;
                    }
                    if (!ItemStackUtil.isSameInCrafting(this.currentEditingItems.m_8020_(j), slot.m_7993_())) continue;
                    found = true;
                }
                if (!found && toPlace != -1) {
                    this.currentEditingItems.setItemNoTrigger(toPlace, slot.m_7993_().m_255036_(1));
                    this.save();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.target;
    }

    public boolean m_5622_(Slot p_38945_) {
        return !(p_38945_ instanceof FilterSlot);
    }

    @Override
    public void save() {
        Player player;
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (this.currentEditingItems.step != null && this.selectedIndex != -1 && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.currentEditingItems.save();
            Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SYNC, this.selectedIndex, 0, this.currentEditingItems.step.toCompound()));
        }
        this.craftGuideData.saveToItemStack(this.target);
        this.craftGuideData.buildInputAndOutputs();
        CraftGuideRenderData.recalculateItemStack(this.target);
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case REMOVE: {
                this.craftGuideData.getSteps().remove(key);
                for (int i = key; i < this.craftGuideData.getSteps().size() - 1; ++i) {
                    this.blockIndicatorForSteps.get(i).m_5852_(this.blockIndicatorForSteps.get(i + 1).m_7993_());
                }
                if (key == this.selectedIndex) {
                    this.selectedIndex = -1;
                    this.currentEditingItems.clearStep();
                }
                this.save();
                break;
            }
            case SELECT: {
                if (this.selectedIndex == key) {
                    this.currentEditingItems.clearStep();
                    this.selectedIndex = -1;
                    this.blockIndicator.m_5852_(ItemStack.f_41583_);
                    this.recalcSlots();
                    return;
                }
                this.selectedIndex = key;
                this.currentEditingItems.setStep(this.craftGuideData.getSteps().get(key));
                this.blockIndicator.m_5852_(this.player.m_9236_().m_8055_(this.craftGuideData.getSteps().get((int)key).storage.pos).m_60734_().m_5456_().m_7968_());
                this.isHandRelated = this.craftGuideData.getSteps().get((int)key).actionType.hasMark(2L);
                this.recalcSlots();
                break;
            }
            case DOWN: {
                if (this.selectedIndex >= this.craftGuideData.getSteps().size() - 1 || this.selectedIndex == -1) break;
                this.swapStep(this.selectedIndex, this.selectedIndex + 1);
                break;
            }
            case UP: {
                if (this.selectedIndex <= 0) break;
                this.swapStep(this.selectedIndex, this.selectedIndex - 1);
                break;
            }
            case SET_MODE: {
                if (data == null) break;
                ResourceLocation action = new ResourceLocation(data.m_128461_("ns"), data.m_128461_("id"));
                this.currentEditingItems.setAction(action);
                this.recalcSlots();
                this.save();
                break;
            }
            case OPTION: {
                if (data != null) {
                    this.currentEditingItems.setOption(key, value, data.m_128461_("value"));
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
                break;
            }
            case COUNT: {
                Container container = this.m_38853_((int)key).f_40218_;
                if (!(container instanceof CommonStepDataContainer)) break;
                CommonStepDataContainer commonStepDataContainer = (CommonStepDataContainer)container;
                commonStepDataContainer.setCount(this.m_38853_(key).m_150661_(), value);
                commonStepDataContainer.m_6596_();
                break;
            }
            case SIDE: {
                this.currentEditingItems.step.storage.side = value == -1 ? null : Direction.values()[value];
                this.save();
                break;
            }
            case SET_ALL_INPUT: {
                ListTag inputTag = data.m_128437_("inputs", 10);
                ListTag outputTag = data.m_128437_("outputs", 10);
                int inputId = 0;
                int outputId = 0;
                CommonStepDataContainer _tmp = new CommonStepDataContainer(this);
                for (int id = 0; id < this.craftGuideData.steps.size(); ++id) {
                    int i;
                    CommonStepDataContainer step;
                    CommonStepDataContainer commonStepDataContainer = step = id == this.selectedIndex ? this.currentEditingItems : _tmp;
                    if (id != this.selectedIndex) {
                        step.setStep(this.craftGuideData.steps.get(id));
                    }
                    for (i = 0; i < step.step.actionType.inputCount(); ++i) {
                        if (inputId >= inputTag.size()) continue;
                        ItemStack tmp = ItemStackUtil.parseStack(inputTag.m_128728_(inputId));
                        step.setItemNoTrigger(i, tmp);
                        step.setCount(i, tmp.m_41613_());
                        ++inputId;
                    }
                    for (i = 0; i < step.step.actionType.outputCount(); ++i) {
                        if (outputId >= outputTag.size()) continue;
                        int inputOffset = step.padCount + step.inputCount;
                        ItemStack tmp = ItemStackUtil.parseStack(outputTag.m_128728_(outputId));
                        step.setItemNoTrigger(inputOffset + i, tmp);
                        step.setCount(inputOffset + i, tmp.m_41613_());
                        ++outputId;
                    }
                    if (id == this.selectedIndex) continue;
                    step.save();
                }
                this.save();
                break;
            }
            case SYNC: {
                if (data == null) break;
                this.craftGuideData.steps.set(key, CraftGuideStepData.fromCompound(data));
                break;
            }
            case GLOBAL: {
                switch (key) {
                    case 0: {
                        this.craftGuideData.isMergeable(value == 1);
                        break;
                    }
                    case 1: {
                        this.craftGuideData.isNoOccupy(value == 1);
                        break;
                    }
                }
                this.save();
            }
        }
    }

    private void recalcSlots() {
        for (int i = 0; i < this.filterSlots.length; ++i) {
            if (i < this.currentEditingItems.inputCount) {
                this.filterSlots[i].setActive(true);
                continue;
            }
            if (i < this.currentEditingItems.inputCount + this.currentEditingItems.padCount) {
                this.filterSlots[i].setActive(false);
                continue;
            }
            this.filterSlots[i].setActive(true);
        }
    }

    private void swapStep(int i, int j) {
        if (i == j) {
            return;
        }
        CraftGuideStepData tmpStepData = this.craftGuideData.getSteps().get(i);
        this.craftGuideData.getSteps().set(i, this.craftGuideData.getSteps().get(j));
        this.craftGuideData.getSteps().set(j, tmpStepData);
        if (this.selectedIndex == i) {
            this.selectedIndex = j;
        } else if (this.selectedIndex == j) {
            this.selectedIndex = i;
        }
        this.save();
    }
}

