/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.ItemHandler;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ContextItemHandlerCollect;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ContextItemHandlerStore;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ContextItemHandlerView;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.AbstractFilterableBlockStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;

public class ItemHandlerStorage
implements IMaidStorage {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "item_handler");

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public boolean isValidTarget(ServerLevel level, LivingEntity maid, BlockPos block, @Nullable Direction side, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity == null) {
            return false;
        }
        @NotNull LazyOptional cap = side == null ? blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER) : blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        return cap.isPresent();
    }

    @Override
    @Nullable
    public IStorageContext onStartCollect(ServerLevel level, EntityMaid maid, Target storage) {
        return new ContextItemHandlerCollect();
    }

    @Override
    @Nullable
    public IStorageContext onStartPlace(ServerLevel level, EntityMaid maid, Target storage) {
        return new ContextItemHandlerStore();
    }

    @Override
    @Nullable
    public IStorageContext onStartView(ServerLevel level, EntityMaid maid, Target storage) {
        return new ContextItemHandlerView();
    }

    @Override
    @Nullable
    public IStorageContext onPreviewFilter(ServerLevel level, EntityMaid maid, Target storage) {
        return new AbstractFilterableBlockStorage();
    }
}

