/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.client.tooltip.RecipeDataTooltip;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0.CookData;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.ingredient.RecIngredient;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.RecDataUse;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.IndexRange;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.FluidRecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.ItemAmount;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import com.github.wallev.maidsoulkitchen.util.MathUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecSerializerManager<R extends Recipe<? extends Container>> {
    public static final LinkedList<MaidRec> EMPTY_LIST = new LinkedList();
    protected final RecipeType<R> recipeType;
    protected final RecipeInfoProvider<R> recipeInfoProvider;
    protected List<MKRecipe<R>> recipes;
    protected List<ItemStack> fuels;

    protected RecSerializerManager(RecipeType<R> recipeType) {
        this.recipeType = recipeType;
        this.recipeInfoProvider = this.createRecipeInfoProvider();
    }

    protected RecipeInfoProvider<R> createRecipeInfoProvider() {
        return RecipeInfoProvider.getInstance();
    }

    public LinkedList<MaidRec> createMaidRecs(List<MKRecipe<R>> recs, Map<ItemDefinition, Long> available, BiConsumer<MKRecipe<R>, IndexRange> successAdd, Predicate<MKRecipe<R>> rIsValid, Predicate<RecDataUse> recDataUsePredicate, Consumer<Boolean> doneConsumer) {
        LinkedList<MaidRec> maidRecs = new LinkedList<MaidRec>();
        IndexRange indexRange = new IndexRange();
        RecDataUse recDataUse = new RecDataUse();
        int index = 0;
        for (MKRecipe<R> r : recs) {
            List<MaidRec> maidRec;
            int size;
            if (!rIsValid.test(r) || (size = (maidRec = this.createMaidRec(r, available, recDataUse)).size()) == 0) continue;
            boolean test = recDataUsePredicate.test(recDataUse);
            if (test) {
                maidRecs.addAll(maidRec);
                indexRange.set(index, size);
                successAdd.accept(r, indexRange);
                index += size;
                continue;
            }
            doneConsumer.accept(true);
            break;
        }
        return maidRecs;
    }

    protected List<MaidRec> createMaidRec(MKRecipe<R> r, Map<ItemDefinition, Long> available, RecDataUse recDataUse) {
        ArrayList<ItemDefinition> invIngredient = new ArrayList<ItemDefinition>();
        HashMap<ItemDefinition, ItemAmount> itemTimes = new HashMap<ItemDefinition, ItemAmount>();
        boolean[] single = new boolean[]{false};
        List<MaidRec> maidRecs = this.recProcess(r, available, invIngredient, single, itemTimes);
        if (!maidRecs.isEmpty()) {
            recDataUse.set(itemTimes, maidRecs.size());
        }
        return maidRecs;
    }

    protected List<MaidRec> recProcess(MKRecipe<R> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        boolean processRecIngres = this.processRecIngres(r, available, invIngredient, single, itemTimes);
        if (!processRecIngres) {
            return Collections.emptyList();
        }
        return this.createCookRec(r, available, single, invIngredient, itemTimes);
    }

    protected boolean processRecIngres(MKRecipe<R> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        for (RecIngredient ingredient : r.inItems()) {
            boolean hasIngredient = false;
            for (Map.Entry<ItemDefinition, Long> entry : available.entrySet()) {
                int amount;
                ItemDefinition key = entry.getKey();
                Long value = entry.getValue();
                Item item = key.item();
                ItemStack stack = key.toStack(value);
                int test = ingredient.test(stack);
                if (test <= 0) continue;
                invIngredient.add(key);
                hasIngredient = true;
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    itemAmount = new ItemAmount(test);
                    itemTimes.put(key, itemAmount);
                    amount = itemAmount.needCount();
                } else {
                    itemAmount = itemTimes.computeIfAbsent(key, k -> new ItemAmount(test, 0));
                    itemAmount.addCount();
                    amount = itemAmount.needCount();
                }
                if (value >= (long)amount) break;
                return false;
            }
            if (hasIngredient) continue;
            return false;
        }
        return true;
    }

    protected List<MaidRec> createCookRec(MKRecipe<R> r, Map<ItemDefinition, Long> available, boolean[] single, List<ItemDefinition> invIngredient, Map<ItemDefinition, ItemAmount> itemTimes) {
        int canCookAmount;
        ItemStack result = r.output();
        ArrayList<MaidItem> maidItems = new ArrayList<MaidItem>();
        int amount = canCookAmount = this.getMaxAmount(available, single, itemTimes);
        boolean isSingle = single[0] || r.isSingle();
        int endAmount = 1;
        if (isSingle) {
            amount = 1;
            endAmount = canCookAmount;
        }
        for (ItemDefinition definition : invIngredient) {
            ItemAmount itemAmount = itemTimes.get(definition);
            int minAmount = itemAmount.getAmount();
            itemAmount.setRecAmount(amount);
            int count = amount * minAmount;
            maidItems.add(new MaidItem(definition, count));
            available.put(definition, available.get(definition) - (long)count * (long)endAmount);
        }
        MaidRec maidRec = new MaidRec((Recipe<?>)r.rec(), result, amount, (List<MaidItem>)maidItems);
        return this.generateRecs(maidRec, endAmount);
    }

    protected List<MaidRec> createCookRec(MKRecipe<R> r, ItemStack tool, Map<ItemDefinition, Long> available, boolean[] single, List<ItemDefinition> invIngredient, Map<ItemDefinition, ItemAmount> itemTimes) {
        int canCookAmount;
        ItemStack result = r.output();
        ArrayList<MaidItem> maidItems = new ArrayList<MaidItem>();
        int amount = canCookAmount = this.getMaxAmount(available, single, itemTimes);
        boolean isSingle = single[0] || r.isSingle();
        int endAmount = 1;
        if (isSingle) {
            amount = 1;
            endAmount = canCookAmount;
        }
        for (ItemDefinition definition : invIngredient) {
            ItemAmount itemAmount = itemTimes.get(definition);
            itemAmount.setRecAmount(amount);
            int minAmount = itemAmount.getAmount();
            int count = amount * minAmount;
            maidItems.add(new MaidItem(definition, count));
            available.put(definition, available.get(definition) - (long)count * (long)endAmount);
        }
        MaidRec maidRec = new MaidRec((Recipe<?>)r.rec(), result, amount, tool, (List<MaidItem>)maidItems);
        return this.generateRecs(maidRec, endAmount);
    }

    protected List<MaidRec> generateRecs(MaidRec maidRec, int count) {
        ArrayList<MaidRec> maidRecList = new ArrayList<MaidRec>(count);
        for (int i = 0; i < count; ++i) {
            maidRecList.add(maidRec);
        }
        return maidRecList;
    }

    protected int getMaxAmount(Map<ItemDefinition, Long> available, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        int maxCount = 64;
        for (ItemDefinition itemDefinition : itemTimes.keySet()) {
            if (itemDefinition.getMaxStackSize() == 1) {
                maxCount = MathUtil.min(maxCount, (int)(available.get(itemDefinition) / (long)itemTimes.get(itemDefinition).needCount()));
                continue;
            }
            maxCount = MathUtil.min(maxCount, itemDefinition.getMaxStackSize(), (int)(available.get(itemDefinition) / (long)itemTimes.get(itemDefinition).needCount()));
        }
        return maxCount;
    }

    protected final ItemStack getStack(Item item) {
        return ItemStackUtil.getItemStack(item);
    }

    public final List<MKRecipe<R>> getRecipes(Level level) {
        this.initRecs(level);
        return this.recipes;
    }

    protected void initRecs(Level level) {
        this.recipes = this.createDefaultRecs(level);
    }

    protected void initFuels() {
        this.fuels = Collections.emptyList();
    }

    protected final List<R> getRecsFromRm(Level level) {
        return this.getRecsFromRm(level, this.recipeType);
    }

    protected final List<R> getRecsFromRm(Level level, RecipeType recipeType) {
        return level.m_7465_().m_44013_(recipeType);
    }

    protected final List<MKRecipe<R>> createDefaultRecs(Level level) {
        return this.createTypeRecs(level, this.recipeType);
    }

    protected final List<MKRecipe<R>> createTypeRecs(Level level, RecipeType<?> recipeType) {
        return this.getRecsFromRm(level, recipeType).stream().map(this::createMKRecipe).toList();
    }

    protected MKRecipe<R> createMKRecipe(R r) {
        List<RecIngredient> ingredients = this.recipeInfoProvider.getIngredients(this, r);
        ItemStack output = this.recipeInfoProvider.getOutput(this, r);
        ItemStack container = this.recipeInfoProvider.getContainer(this, r);
        boolean single = this.recipeInfoProvider.isSingle(this, r);
        return new MKRecipe<R>(r, single, ingredients, output, container);
    }

    protected MKRecipe<R> createMKRecipe(R r, List<ItemStack> inFluids) {
        List<RecIngredient> ingredients = this.recipeInfoProvider.getIngredients(this, r);
        ItemStack output = this.recipeInfoProvider.getOutput(this, r);
        ItemStack container = this.recipeInfoProvider.getContainer(this, r);
        boolean single = this.recipeInfoProvider.isSingle(this, r);
        return new MKRecipe<R>(r, single, inFluids, ingredients, output, container);
    }

    public RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public String getRecipeTypeId() {
        return this.recipeType.toString();
    }

    public boolean isItem(List<ItemStack> itemStacks, Item item) {
        return ItemStackUtil.isItem(itemStacks, item);
    }

    public boolean isItem(List<ItemStack> itemStacks, ItemStack itemStack) {
        return this.isItem(itemStacks, itemStack.m_41720_());
    }

    public FluidRecSerializerManager<R> toFluid() {
        return (FluidRecSerializerManager)this.to();
    }

    public <RSM extends RecSerializerManager<R>> RSM to() {
        return (RSM)this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<TooltipComponent> getRecClientAmountTooltip(MKRecipe<?> recipe, boolean modeIsBlacklist, boolean overSize, CookData cookData, EntityMaid maid) {
        ItemStack container;
        ArrayList<RecipeDataTooltip.TooltipRecIngredient> tooltips = new ArrayList<RecipeDataTooltip.TooltipRecIngredient>();
        List<ItemStack> inFluids = recipe.inFluids();
        List<RecIngredient> ingredients = recipe.inItems();
        if (!ingredients.isEmpty() || !inFluids.isEmpty()) {
            ArrayList<Ingredient> ingredientAll = new ArrayList<Ingredient>();
            if (!inFluids.isEmpty()) {
                ingredientAll.add(Ingredient.m_43921_(inFluids.stream()));
            }
            if (!ingredients.isEmpty()) {
                List<Ingredient> ingredients1 = ingredients.stream().map(r -> r.ingredient).toList();
                ingredientAll.addAll(ingredients1);
            }
            tooltips.add(this.getTooltipReIngreIngredient(ingredientAll, maid));
        }
        if (!(container = recipe.container()).m_41619_()) {
            tooltips.add(this.getTooltipRecOutputContainerIngredient(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{container})), maid));
        }
        List<ItemStack> fuels = this.getFuels();
        RecipeDataTooltip.TooltipRecipeData tooltipRecipeData = new RecipeDataTooltip.TooltipRecipeData(cookData, recipe.id().toString(), tooltips, this.getTooltipRecResultIngredient(recipe, maid), modeIsBlacklist, overSize);
        return Optional.of(tooltipRecipeData);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected RecipeDataTooltip.TooltipRecIngredient getTooltipReIngreIngredient(List<Ingredient> ingredientList, EntityMaid maid) {
        ArrayList<List<RecipeDataTooltip.IngredientSourceType>> list = new ArrayList<List<RecipeDataTooltip.IngredientSourceType>>();
        list.add(List.of(RecipeDataTooltip.IngredientSourceType.MAIN_HAND, RecipeDataTooltip.IngredientSourceType.OFF_HAND, RecipeDataTooltip.IngredientSourceType.MAID_BACKPACK));
        list.add(List.of(RecipeDataTooltip.IngredientSourceType.HUB_INGREDIENT));
        int resultRuleMatchIndex = ItemCulinaryHub.hasItem(maid) ? 1 : 0;
        RecipeDataTooltip.TooltipRecIngredient tooltipRecResultIngredient = new RecipeDataTooltip.TooltipRecIngredient(ingredientList, list, RecipeDataTooltip.IngredientType.MANDATORY, resultRuleMatchIndex);
        return tooltipRecResultIngredient;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected RecipeDataTooltip.TooltipRecIngredient getTooltipRecResultIngredient(MKRecipe<?> recipe, EntityMaid maid) {
        ItemStack resultClient = recipe.output();
        ArrayList<List<RecipeDataTooltip.IngredientSourceType>> list = new ArrayList<List<RecipeDataTooltip.IngredientSourceType>>();
        list.add(List.of(RecipeDataTooltip.IngredientSourceType.MAIN_HAND, RecipeDataTooltip.IngredientSourceType.OFF_HAND, RecipeDataTooltip.IngredientSourceType.MAID_BACKPACK));
        list.add(List.of(RecipeDataTooltip.IngredientSourceType.HUB_OUTPUT));
        int resultRuleMatchIndex = ItemCulinaryHub.hasItem(maid) ? 1 : 0;
        RecipeDataTooltip.TooltipRecIngredient tooltipRecResultIngredient = new RecipeDataTooltip.TooltipRecIngredient(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{resultClient})), list, RecipeDataTooltip.IngredientType.OUTPUT, resultRuleMatchIndex);
        return tooltipRecResultIngredient;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected RecipeDataTooltip.TooltipRecIngredient getTooltipRecOutputContainerIngredient(List<Ingredient> outputContainers, EntityMaid maid) {
        ArrayList<List<RecipeDataTooltip.IngredientSourceType>> list = new ArrayList<List<RecipeDataTooltip.IngredientSourceType>>();
        list.add(Lists.newArrayList((Object[])new RecipeDataTooltip.IngredientSourceType[]{RecipeDataTooltip.IngredientSourceType.MAIN_HAND, RecipeDataTooltip.IngredientSourceType.OFF_HAND, RecipeDataTooltip.IngredientSourceType.MAID_BACKPACK}));
        list.add(Lists.newArrayList((Object[])new RecipeDataTooltip.IngredientSourceType[]{RecipeDataTooltip.IngredientSourceType.HUB_OUTPUT_ADDITION}));
        int containerRuleMatchIndex = ItemCulinaryHub.hasItem(maid) ? 1 : 0;
        RecipeDataTooltip.TooltipRecIngredient tooltipRecContainerSources = new RecipeDataTooltip.TooltipRecIngredient(outputContainers, list, RecipeDataTooltip.IngredientType.MAYBE, containerRuleMatchIndex);
        return tooltipRecContainerSources;
    }

    public List<ItemStack> getFuels() {
        if (this.fuels == null) {
            this.initFuels();
        }
        return this.fuels;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected RecipeDataTooltip.TooltipRecIngredient getTooltipRecFuelIngredient(List<Ingredient> fuels, EntityMaid maid) {
        ArrayList<List<RecipeDataTooltip.IngredientSourceType>> list = new ArrayList<List<RecipeDataTooltip.IngredientSourceType>>();
        list.add(Lists.newArrayList((Object[])new RecipeDataTooltip.IngredientSourceType[]{RecipeDataTooltip.IngredientSourceType.MAIN_HAND, RecipeDataTooltip.IngredientSourceType.OFF_HAND, RecipeDataTooltip.IngredientSourceType.MAID_BACKPACK}));
        int containerRuleMatchIndex = 0;
        RecipeDataTooltip.TooltipRecIngredient tooltipRecContainerSources = new RecipeDataTooltip.TooltipRecIngredient(fuels, list, RecipeDataTooltip.IngredientType.MAYBE, containerRuleMatchIndex);
        return tooltipRecContainerSources;
    }

    public final List<ItemStack> createDefaultFuels() {
        return ItemStackUtil.getDefaultFuels();
    }

    public static class RecipeInfoProvider<R extends Recipe<? extends Container>> {
        private static final RecipeInfoProvider INSTANCE = new RecipeInfoProvider();

        public static <R extends Recipe<? extends Container>> RecipeInfoProvider<R> getInstance() {
            return INSTANCE;
        }

        public List<RecIngredient> getIngredients(RecSerializerManager<R> rsm, R rec) {
            return RecIngredient.from((List<Ingredient>)rec.m_7527_());
        }

        public ItemStack getOutput(RecSerializerManager<R> rsm, R rec) {
            return rec.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        }

        public ItemStack getContainer(RecSerializerManager<R> rsm, R rec) {
            return ItemStack.f_41583_;
        }

        public boolean isSingle(RecSerializerManager<R> rsm, R rec) {
            return false;
        }

        public final <RP0 extends RecipeInfoProvider<R0>, R0 extends Recipe<? extends Container>> RP0 to() {
            return (RP0)this;
        }
    }
}

