/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.overlay;

import com.github.wallev.maidsoulkitchen.init.MkItems;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class CulinaryHubOverlay
implements IGuiOverlay {
    private static String getTranslateKey(String bindMode) {
        switch (bindMode) {
            case "Ingredient": {
                return BagType.INGREDIENT.translateKey;
            }
            case "StartAddition": {
                return BagType.START_ADDITION.translateKey;
            }
            case "IngredientAddition": {
                return BagType.INGREDIENT_ADDITION.translateKey;
            }
            case "OutputAddition": {
                return BagType.OUTPUT_ADDITION.translateKey;
            }
            case "Output": {
                return BagType.OUTPUT.translateKey;
            }
        }
        return "";
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        Options options = minecraft.f_91066_;
        if (!options.m_92176_().m_90612_()) {
            return;
        }
        if (minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            return;
        }
        BlockPos hitResultBlockPos = blockHitResult.m_82425_();
        BlockEntity blockEntity = player.m_9236_().m_7702_(hitResultBlockPos);
        if (blockEntity != null && ItemCulinaryHub.getBeInv(blockEntity) != null) {
            boolean binded = false;
            Map<BagType, List<BlockPos>> bindPoses = ItemCulinaryHub.getBindPoses(mainHandItem);
            ArrayList<MutableComponent> bindedComponents = new ArrayList<MutableComponent>();
            bindedComponents.add(Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.already_bind_types").m_130940_(ChatFormatting.GRAY));
            MutableComponent component = Component.m_237119_().m_130940_(ChatFormatting.GRAY);
            int index = bindPoses.size();
            for (Map.Entry<BagType, List<BlockPos>> bagType : bindPoses.entrySet()) {
                BagType type = bagType.getKey();
                boolean canDisplay = true;
                for (BagType displayVal : BagType.DISPLAY_VALS) {
                    if (displayVal == type) continue;
                    canDisplay = false;
                    break;
                }
                if (!canDisplay) continue;
                MutableComponent bindModeComponent = Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + type.translateKey));
                if (!bagType.getValue().contains(hitResultBlockPos)) continue;
                component.m_7220_((Component)bindModeComponent);
                if (--index > 0) {
                    component.m_130946_(", ");
                }
                binded = true;
            }
            bindedComponents.add(component);
            ArrayList tips = Lists.newArrayList();
            if (!binded) {
                tips.add(Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.can_sneak_bind").m_130940_(ChatFormatting.GRAY));
                String bindMode = ItemCulinaryHub.getBindMode(mainHandItem);
                if (bindMode.isEmpty()) {
                    tips.add(Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.right_click_to_bind").m_130940_(ChatFormatting.GRAY));
                } else {
                    int size = ItemCulinaryHub.getBindModePoses(mainHandItem, bindMode).size();
                    tips.add(Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.current_binding_type").m_7220_((Component)Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + CulinaryHubOverlay.getTranslateKey(bindMode)))).m_7220_((Component)Component.m_237113_((String)String.format("[%s/%s]", size, 3))).m_130940_(ChatFormatting.GRAY));
                }
            } else {
                tips.addAll(bindedComponents);
            }
            gui.setupOverlayRenderState(true, false);
            int offset = screenHeight / 2 + 5;
            for (Component tip : tips) {
                int width = minecraft.f_91062_.m_92852_((FormattedText)tip);
                guiGraphics.m_280430_(minecraft.f_91062_, tip, (screenWidth - width) / 2, offset, 0xFFFFFF);
                Objects.requireNonNull(minecraft.f_91062_);
                offset += 9 + 1;
            }
        }
    }
}

