/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.event.BlackHubChestDefineEvent;
import com.github.wallev.maidsoulkitchen.init.MkItems;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagAbstractContainer;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagConfigContainer;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagContainer;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemCulinaryHub
extends Item
implements MenuProvider {
    public static final float WORK_RANGE = 2.5f;
    public static final int OUTPUT_INV_SLOT_SIZE = ItemCulinaryHub.outputSlotSize();
    public static final int BIND_SIZE = 3;
    public static final BagType[] INPUT_BAG_TYPES = BagType.INPUT_VALS;
    public static final int INPUT_INV_SLOT_SIZE = ItemCulinaryHub.inputSlotSize();
    private static final int INV_SLOT = 4;
    private static final int COOK_BAG_SIZE = ItemCulinaryHub.getCookBagSize();
    private static final String CONTAINER_TAG = "CulinaryHubContainer";
    private static final String BIND_MODE_TAG = "CulinaryHubBindMode";
    private static final String BIND_POS_TAG = "CulinaryHubBindPos";

    public ItemCulinaryHub() {
        super(new Item.Properties().m_41487_(1));
    }

    private static int inputSlotSize() {
        int slot = 0;
        for (BagType inputBagType : INPUT_BAG_TYPES) {
            slot += inputBagType.size;
        }
        return slot;
    }

    private static int outputSlotSize() {
        return BagType.OUTPUT.size;
    }

    public static boolean hasItem(EntityMaid maid) {
        return !ItemCulinaryHub.getItem(maid).m_41619_();
    }

    public static ItemStack getItem(EntityMaid maid) {
        ItemStack stack = maid.getMaidInv().getStackInSlot(4);
        return stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) ? stack : ItemStack.f_41583_;
    }

    public static CombinedInvWrapper getInputInv(ItemStack hubStack) {
        ItemStackHandler[] handlers;
        block5: {
            handlers = new ItemStackHandler[INPUT_BAG_TYPES.length];
            if (!hubStack.m_150930_((Item)MkItems.CULINARY_HUB.get())) break block5;
            CompoundTag tag = hubStack.m_41783_();
            if (tag == null || !tag.m_128425_(CONTAINER_TAG, 10)) {
                int i = 0;
                for (BagType type : INPUT_BAG_TYPES) {
                    ItemStackHandler handler;
                    handlers[i] = handler = new ItemStackHandler(type.size * 9);
                }
            } else {
                CompoundTag compound = tag.m_128469_(CONTAINER_TAG);
                int i = 0;
                for (BagType type : INPUT_BAG_TYPES) {
                    ItemStackHandler handler = new ItemStackHandler(type.size * 9);
                    if (compound.m_128425_(type.name, 10)) {
                        handler.deserializeNBT(compound.m_128469_(type.name));
                    }
                    handlers[i++] = handler;
                }
            }
        }
        return new CombinedInvWrapper((IItemHandlerModifiable[])handlers);
    }

    public static ItemStackHandler getOutputInv(ItemStack hubStack) {
        if (hubStack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag tag = hubStack.m_41783_();
            if (tag == null || !tag.m_128425_(CONTAINER_TAG, 10)) {
                return new ItemStackHandler(OUTPUT_INV_SLOT_SIZE);
            }
            CompoundTag compound = tag.m_128469_(CONTAINER_TAG);
            BagType output = BagType.OUTPUT;
            ItemStackHandler handler = new ItemStackHandler(output.size * 9);
            if (compound.m_128425_(output.name, 10)) {
                handler.deserializeNBT(compound.m_128469_(output.name));
            }
            return handler;
        }
        return new ItemStackHandler(OUTPUT_INV_SLOT_SIZE);
    }

    public static void removeModePoses(ItemStack stack) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag compound = tag.m_128469_(BIND_POS_TAG);
            for (BagType value : BagType.VALS) {
                compound.m_128473_(value.name);
            }
            tag.m_128365_(BIND_POS_TAG, (Tag)compound);
        }
    }

    public static void actionModePos(ItemStack stack, String mode, BlockPos blockPos) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && !mode.isEmpty()) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag compound = tag.m_128469_(BIND_POS_TAG);
            ListTag list = compound.m_128437_(mode, 10);
            AtomicBoolean remove = new AtomicBoolean(false);
            list.removeIf(tag1 -> {
                if (NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag1)).equals((Object)blockPos)) {
                    remove.set(true);
                    return true;
                }
                return false;
            });
            if (!remove.get()) {
                list.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
                compound.m_128365_(mode, (Tag)list);
            }
            tag.m_128365_(BIND_POS_TAG, (Tag)compound);
        }
    }

    public static List<BlockPos> getBindModePoses(ItemStack stack, String mode) {
        CompoundTag tag;
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null && tag.m_128425_(BIND_POS_TAG, 10)) {
            CompoundTag tag1 = tag.m_128469_(BIND_POS_TAG);
            ListTag list = tag1.m_128437_(mode, 10);
            return list.stream().map(tag2 -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag2))).toList();
        }
        return Collections.emptyList();
    }

    public static Map<BagType, List<BlockPos>> getBindPoses(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null && tag.m_128425_(BIND_POS_TAG, 10)) {
            CompoundTag tag1 = tag.m_128469_(BIND_POS_TAG);
            HashMap<BagType, List<BlockPos>> typeListHashMap = new HashMap<BagType, List<BlockPos>>();
            for (BagType value : BagType.VALS) {
                ListTag list = tag1.m_128437_(value.name, 10);
                List<BlockPos> poses = list.stream().map(tag2 -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag2))).toList();
                typeListHashMap.put(value, poses);
            }
            return typeListHashMap;
        }
        return Map.of();
    }

    public static boolean isExtraZone(EntityMaid maid, BlockPos pos) {
        float maxDistance = maid.m_21535_() * 2.5f;
        BlockPos centerPos = ICookTask.getSearchPos(maid);
        return !centerPos.m_203195_((Position)pos.m_252807_(), (double)maxDistance);
    }

    public static String getBindMode(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null) {
            return tag.m_128461_(BIND_MODE_TAG);
        }
        return "";
    }

    public static void setBindModeTag(ItemStack stack, String mode) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_(BIND_MODE_TAG, mode);
        }
    }

    private static int getCookBagSize() {
        int size = 0;
        for (BagType value : BagType.VALS) {
            size += value.size * 9;
        }
        return size;
    }

    public static Map<BagType, ItemStackHandler> getContainers(ItemStack stack) {
        HashMap<BagType, ItemStackHandler> bagTypeItemStackHandlerHashMap;
        block5: {
            bagTypeItemStackHandlerHashMap = new HashMap<BagType, ItemStackHandler>();
            if (!stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) break block5;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128425_(CONTAINER_TAG, 10)) {
                for (BagType value : BagType.VALS) {
                    ItemStackHandler handler = new ItemStackHandler(value.size * 9);
                    bagTypeItemStackHandlerHashMap.put(value, handler);
                }
            } else {
                CompoundTag compound = tag.m_128469_(CONTAINER_TAG);
                for (BagType value : BagType.VALS) {
                    ItemStackHandler handler = new ItemStackHandler(value.size * 9);
                    if (compound.m_128425_(value.name, 10)) {
                        handler.deserializeNBT(compound.m_128469_(value.name));
                    }
                    bagTypeItemStackHandlerHashMap.put(value, handler);
                }
            }
        }
        return bagTypeItemStackHandlerHashMap;
    }

    public static void setContainer(ItemStack stack, Map<BagType, ItemStackHandler> handlers) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag orCreateTag = stack.m_41784_();
            CompoundTag compound = orCreateTag.m_128469_(CONTAINER_TAG);
            handlers.forEach((bagType, itemStackHandler) -> compound.m_128365_(bagType.name, (Tag)itemStackHandler.serializeNBT()));
            orCreateTag.m_128365_(CONTAINER_TAG, (Tag)compound);
        }
    }

    public static boolean openCookBagGuiFromSideTab(Player player, int tabIndex) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)ItemCulinaryHub.getGuiProviderFromSideTab(tabIndex), buffer -> buffer.m_130055_(player.m_21205_()));
        }
        return true;
    }

    private static MenuProvider getGuiProviderFromSideTab(int tabIndex) {
        if (tabIndex == 0) {
            return ItemCulinaryHub.getCookBagConfigContainer();
        }
        return ItemCulinaryHub.getCookBagContainer();
    }

    private static MenuProvider getCookBagContainer() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Cook Container");
            }

            public CookBagAbstractContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new CookBagContainer(index, playerInventory, player.m_21205_());
            }
        };
    }

    private static MenuProvider getCookBagConfigContainer() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Cook Config Container");
            }

            public CookBagAbstractContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new CookBagConfigContainer(index, playerInventory, player.m_21205_());
            }
        };
    }

    @Nullable
    public static IItemHandler getBeInv(BlockEntity blockEntity) {
        Set<Block> blacks = BlackHubChestDefineEvent.BLACK_HUB_CHEST_LIST;
        Block block = blockEntity.m_58900_().m_60734_();
        if (blacks.contains(block)) {
            return null;
        }
        return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockEntity te = worldIn.m_7702_(pos);
        if (hand != InteractionHand.MAIN_HAND) {
            return super.m_6225_(context);
        }
        if (player == null || te == null) {
            return super.m_6225_(context);
        }
        IItemHandler beInv = ItemCulinaryHub.getBeInv(te);
        if (beInv != null) {
            String bindMode;
            ItemStack stack = player.m_21205_();
            List<BlockPos> bindModePoses = ItemCulinaryHub.getBindModePoses(stack, bindMode = ItemCulinaryHub.getBindMode(stack));
            if (bindModePoses.size() >= 3 && !bindModePoses.contains(pos)) {
                if (context.m_43725_().f_46443_) {
                    player.m_213846_((Component)VComponent.translatable("message.maidsoulkitchen.culinary_hub.bine_type_max"));
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (!bindMode.isEmpty()) {
                ItemCulinaryHub.actionModePos(stack, bindMode, pos);
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND && playerIn instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)this, buffer -> buffer.m_130055_(playerIn.m_21205_()));
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21205_());
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Cook Bag Container");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CookBagConfigContainer(pContainerId, pPlayerInventory, pPlayer.m_21205_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)VComponent.empty());
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.0").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)VComponent.empty());
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.2").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.3").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)VComponent.empty());
        tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.function").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.function.1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.function.2").m_130940_(ChatFormatting.GRAY));
        Map<BagType, List<BlockPos>> bindPoses = ItemCulinaryHub.getBindPoses(stack);
        ArrayList<Object> leftBindBagTypes = new ArrayList<Object>();
        for (Map.Entry<BagType, List<BlockPos>> entry : bindPoses.entrySet()) {
            BagType type = entry.getKey();
            boolean bl = true;
            for (BagType displayVal : BagType.DISPLAY_VALS) {
                if (displayVal == type) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            leftBindBagTypes.add((Object)type);
        }
        if (bindPoses.isEmpty() || leftBindBagTypes.size() == BagType.VALS.length - 2) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn.empty").m_130940_(ChatFormatting.GRAY));
        } else if (!leftBindBagTypes.isEmpty()) {
            MutableComponent leftComponent1 = Component.m_237119_();
            boolean first = true;
            for (BagType bagType : leftBindBagTypes) {
                if (first) {
                    leftComponent1.m_7220_((Component)VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + bagType.translateKey).m_130940_(ChatFormatting.GRAY));
                    first = false;
                    continue;
                }
                leftComponent1.m_7220_((Component)Component.m_237113_((String)"\u3001").m_7220_((Component)VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + bagType.translateKey).m_130940_(ChatFormatting.GRAY)));
            }
            MutableComponent leftComponent = Component.m_237113_((String)"[").m_7220_((Component)leftComponent1).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn.left", leftComponent).m_130940_(ChatFormatting.GRAY));
        }
    }
}

