/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import studio.fantasyit.maid_storage_manager.Logger;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.IngredientNode;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class RecipeIngredientCache {
    public static final ConcurrentHashMap<ResourceLocation, List<UUID>> CACHE = new ConcurrentHashMap();
    public static final List<CachedIngredient> cachedNode = new ArrayList<CachedIngredient>();
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();

    public static void invalidateAll() {
        LOCK.writeLock().lock();
        CACHE.clear();
        cachedNode.clear();
        LOCK.writeLock().unlock();
    }

    public static boolean isCached(ResourceLocation recipeId) {
        return CACHE.containsKey(recipeId);
    }

    public static boolean addCahcedRecipeToGraph(ICachableGeneratorGraph graph, ResourceLocation id, List<Ingredient> ingredients, List<Integer> ingredientCounts, List<ItemStack> output, Function<List<ItemStack>, CraftGuideData> craftGuideSupplier, ResourceLocation type, boolean isOneTime) {
        if (CACHE.containsKey(id) && CACHE.get(id).size() == ingredients.size()) {
            ArrayList<IngredientNode> ingredientNodes = new ArrayList<IngredientNode>();
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = ingredients.get(i);
                UUID uuid = CACHE.get(id).get(i);
                IngredientNode ingredientNode = graph.addOrGetCahcedIngredientNode(ingredient, uuid);
                ingredientNodes.add(ingredientNode);
            }
            graph.addRecipeWithIngredients(id, ingredients, ingredientCounts, output, ingredientNodes, craftGuideSupplier, type, isOneTime);
            return true;
        }
        if (CACHE.containsKey(id)) {
            Logger.error("Recipe %s was cached with incorrect ingredient count [%d cached and %d added]", id, CACHE.get(id).size(), ingredients.size());
        }
        return false;
    }

    public static void addRecipeCache(Recipe<?> recipe) {
        RecipeIngredientCache.addRecipeCache(recipe.m_6423_(), (List<Ingredient>)recipe.m_7527_());
    }

    public static void addRecipeCache(ResourceLocation id, List<Ingredient> ingredients) {
        if (CACHE.containsKey(id)) {
            Logger.error("Recipe %s has been added for twice", id);
        }
        ArrayList<UUID> cachedIngredientNodeUUID = new ArrayList<UUID>();
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            LOCK.readLock().lock();
            for (CachedIngredient ingredientNode : cachedNode) {
                if (!ingredientNode.isEqualTo(ingredient)) continue;
                found = true;
                cachedIngredientNodeUUID.add(ingredientNode.cachedUUID);
                break;
            }
            LOCK.readLock().unlock();
            if (found) continue;
            LOCK.writeLock().lock();
            UUID uuid = UUID.randomUUID();
            cachedNode.add(new CachedIngredient(ingredient.m_43908_(), uuid));
            cachedIngredientNodeUUID.add(uuid);
            LOCK.writeLock().unlock();
        }
        CACHE.put(id, cachedIngredientNodeUUID);
    }

    public static int getUncachedRecipeIngredient(ResourceLocation id, List<Ingredient> ingredients, ICachableGeneratorGraph generatorGraph) {
        if (!RecipeIngredientCache.isCached(id)) {
            return ingredients.size();
        }
        int c = 0;
        for (UUID ingredient : CACHE.get(id)) {
            if (generatorGraph.hasCachedIngredientNode(ingredient)) continue;
            ++c;
        }
        return c;
    }

    public static void preFetchCache(RecipeManager manager) {
        RecipeIngredientCache.invalidateAll();
        CraftManager.getInstance().getAutoCraftGuideGenerators().forEach(generator -> generator.onCache(manager));
    }

    public static class CachedIngredient {
        public ItemStack[] possibleItems;
        public UUID cachedUUID;

        public CachedIngredient(ItemStack[] possibleItems, UUID cachedUUID) {
            this.possibleItems = possibleItems;
            this.cachedUUID = cachedUUID;
        }

        public boolean isEqualTo(Ingredient ingredient) {
            ItemStack[] items = ingredient.m_43908_();
            if (items.length != this.possibleItems.length) {
                return false;
            }
            for (int i = 0; i < items.length; ++i) {
                if (ItemStackUtil.isSameInCrafting(items[i], this.possibleItems[i])) continue;
                return false;
            }
            return true;
        }
    }
}

