/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableBoolean;
import studio.fantasyit.maid_storage_manager.craft.generator.config.GeneratingConfig;

public class ConfigTypes {

    public static class ConfigType<T> {
        protected String key;
        protected T value;
        protected Component translatableName;
        public ConfigTypeEnum type;
        protected Consumer<T> onChange = null;

        public ConfigType(String key, T value, Component translatableName, ConfigTypeEnum type) {
            this.key = key;
            this.value = value;
            this.translatableName = translatableName;
            this.type = type;
        }

        public void setOnChange(Consumer<T> onChange) {
            this.onChange = onChange;
        }

        public void setValue(T value) {
            this.value = value;
            if (this.onChange != null) {
                this.onChange.accept(value);
            }
            GeneratingConfig.save();
        }

        public T getValue() {
            return this.value;
        }

        public void read(CommentedConfig reader, String base, MutableBoolean changeFlag) {
            this.value = reader.getOrElse(base + "." + this.key, () -> {
                reader.set(base + "." + this.key, this.value);
                changeFlag.setTrue();
                return this.value;
            });
            if (this.onChange != null) {
                this.onChange.accept(this.value);
            }
        }

        public void save(CommentedConfig write, String base) {
            write.set(base + "." + this.key, this.value);
        }

        public Component getTranslatableName() {
            return this.translatableName;
        }
    }

    public static enum ConfigTypeEnum {
        Boolean,
        Integer,
        String,
        Double;

    }
}

