/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.GeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.CraftNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.IngredientNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.ItemNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.Node;

public class CraftGuideGeneratorTester {
    public static void exportTo(GeneratorGraph graph, List<ItemStack> inventory, String path) {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            Node node = graph.getNode(i);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", (Number)node.id);
            jsonObject.addProperty("inqueue", Boolean.valueOf(node.inqueue));
            jsonObject.addProperty("related", Boolean.valueOf(node.related));
            JsonArray edges = new JsonArray();
            node.edges.forEach(e -> {
                JsonObject edge = new JsonObject();
                edge.addProperty("id", (Number)e.getA());
                edge.addProperty("weight", (Number)e.getB());
                edges.add((JsonElement)edge);
            });
            jsonObject.add("edges", (JsonElement)edges);
            JsonArray edgesRev = new JsonArray();
            node.edgesRev.forEach(e -> {
                JsonObject edge = new JsonObject();
                edge.addProperty("id", (Number)e.getA());
                edge.addProperty("weight", (Number)e.getB());
                edgesRev.add((JsonElement)edge);
            });
            jsonObject.add("edgesRev", (JsonElement)edgesRev);
            if (node instanceof ItemNode) {
                ItemNode in = (ItemNode)node;
                jsonObject.addProperty("isAvailable", Boolean.valueOf(in.isAvailable));
                jsonObject.addProperty("type", "item");
            } else if (node instanceof CraftNode) {
                CraftNode cn = (CraftNode)node;
                jsonObject.addProperty("type", "craft");
                jsonObject.addProperty("scheduled", Boolean.valueOf(cn.inqueue));
            } else if (node instanceof IngredientNode) {
                IngredientNode in = (IngredientNode)node;
                jsonObject.addProperty("type", "ingredient");
            }
            jsonObject.addProperty("info", node.toString());
            jsonArray.add((JsonElement)jsonObject);
        }
        JsonArray craftGuides = new JsonArray();
        for (CraftGuideData craftGuideData : graph.getCraftGuides()) {
            craftGuides.add(craftGuideData.toString());
        }
        JsonArray items = new JsonArray();
        for (ItemStack itemStack : inventory) {
            JsonObject item = new JsonObject();
            item.addProperty("id", itemStack.m_41720_().toString());
            item.addProperty("count", (Number)itemStack.m_41613_());
            items.add((JsonElement)item);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("nodes", (JsonElement)jsonArray);
        jsonObject.add("craftGuides", (JsonElement)craftGuides);
        jsonObject.add("items", (JsonElement)items);
        try (FileWriter fileWriter = new FileWriter(path);){
            Gson gson = new GsonBuilder().create();
            gson.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

