/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.ars;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;

public abstract class GeneratorArsNouveauEnchantApp<T extends EnchantingApparatusRecipe>
implements IAutoCraftGuideGenerator {
    protected abstract RegistryObject<RecipeType<T>> getRecipeType();

    @Override
    @NotNull
    public ResourceLocation getType() {
        return Objects.requireNonNull(this.getRecipeType().getId());
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)BlockRegistry.ENCHANTING_APP_BLOCK.get()) && level.m_8055_(pos.m_7495_()).m_60713_((Block)BlockRegistry.ARCANE_CORE_BLOCK.get());
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EnchantingApparatusTile) {
            EnchantingApparatusTile tile = (EnchantingApparatusTile)blockEntity;
            List blockPos = tile.pedestalList();
            level.m_7465_().m_44013_((RecipeType)this.getRecipeType().get()).forEach(recipe -> {
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(recipe.pedestalItems);
                ingredients.add(recipe.reagent);
                if (recipe.pedestalItems.size() <= blockPos.size()) {
                    graph.addRecipe(recipe.m_6423_(), ingredients, ingredients.stream().map(t -> 1).toList(), recipe.result, items -> {
                        ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                        for (int i = 0; i < items.size() - 1; ++i) {
                            steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, (BlockPos)blockPos.get(i)), List.of((ItemStack)items.get(i)), List.of(), CommonPlaceItemAction.TYPE));
                        }
                        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of((ItemStack)items.get(items.size() - 1)), List.of(), CommonPlaceItemAction.TYPE));
                        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), List.of(recipe.result), CommonTakeItemAction.TYPE));
                        return new CraftGuideData(steps, CommonType.TYPE);
                    });
                }
            });
        }
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_((RecipeType)this.getRecipeType().get()).forEach(t -> {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(t.pedestalItems);
            ingredients.add(t.reagent);
            RecipeIngredientCache.addRecipeCache(t.id, ingredients);
        });
    }
}

