/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.data.BoxTip;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;

@OnlyIn(value=Dist.CLIENT)
public class InventoryListDataClient {
    public static List<Pair<InventoryItem, MutableInt>> showingInv = new ArrayList<Pair<InventoryItem, MutableInt>>();
    public static List<Pair<BoxTip, MutableInt>> commonTips = new ArrayList<Pair<BoxTip, MutableInt>>();
    private static InventoryListDataClient instance;
    public Map<UUID, List<InventoryItem>> dataMap = new ConcurrentHashMap<UUID, List<InventoryItem>>();
    Set<UUID> requestSet = new HashSet<UUID>();

    public static InventoryListDataClient getInstance() {
        if (instance == null) {
            instance = new InventoryListDataClient();
        }
        return instance;
    }

    public static void setShowingInv(InventoryItem inventoryItem, int i) {
        showingInv.add((Pair<InventoryItem, MutableInt>)new Pair((Object)inventoryItem, (Object)new MutableInt(i)));
    }

    public static void addCommonTip(BoxTip tip) {
        commonTips.add((Pair<BoxTip, MutableInt>)new Pair((Object)tip, (Object)new MutableInt(tip.maxTime())));
    }

    public static void clearShowingInv() {
        showingInv.clear();
        commonTips.clear();
    }

    public static void tickShowingInv() {
        Integer value;
        int i;
        for (i = showingInv.size() - 1; i >= 0; --i) {
            ((MutableInt)showingInv.get(i).getB()).subtract(1);
            value = ((MutableInt)showingInv.get(i).getB()).getValue();
            if (value > 0) continue;
            showingInv.remove(i);
        }
        for (i = commonTips.size() - 1; i >= 0; --i) {
            ((MutableInt)commonTips.get(i).getB()).subtract(1);
            value = ((MutableInt)commonTips.get(i).getB()).getValue();
            if (value > 0) continue;
            commonTips.remove(i);
        }
    }

    public void patch(UUID uuid, List<InventoryItem> map) {
        for (InventoryItem pair : map) {
            List pairs = this.dataMap.computeIfAbsent(uuid, k -> new ArrayList());
            boolean found = false;
            for (int i = 0; i < pairs.size(); ++i) {
                InventoryItem pair1 = (InventoryItem)pairs.get(i);
                if (!ItemStack.m_150942_((ItemStack)pair1.itemStack, (ItemStack)pair.itemStack)) continue;
                pairs.set(i, pair);
                found = true;
                break;
            }
            if (found) continue;
            pairs.add(pair);
        }
    }

    public void requestForDataIfFirstTime(UUID uuid) {
        if (this.requestSet.contains(uuid)) {
            return;
        }
        Network.sendRequestListPacket(uuid);
        this.requestSet.add(uuid);
    }

    public List<InventoryItem> get(UUID uuid) {
        return this.dataMap.getOrDefault(uuid, new ArrayList());
    }

    public void tickRequest() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            for (ItemStack i : player.f_36093_.f_35974_) {
                if (!i.m_150930_((Item)ItemRegistry.WRITTEN_INVENTORY_LIST.get()) || !i.m_41782_() || !i.m_41783_().m_128441_("uuid")) continue;
                this.requestForDataIfFirstTime(i.m_41783_().m_128342_("uuid"));
            }
        }
    }
}

