/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidPickupEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import studio.fantasyit.maid_storage_manager.capability.CraftBlockOccupyDataProvider;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

@Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MaidItemPickupEvent {
    @SubscribeEvent
    public static void onItemPickup(MaidPickupEvent.ItemResultPre event) {
        ItemEntity entityItem;
        EntityMaid maid = event.getMaid();
        if (MemoryUtil.canPickUpItemTemp(maid, (entityItem = event.getEntityItem()).m_20148_())) {
            return;
        }
        if (MemoryUtil.isWorking(maid)) {
            event.setCanceled(true);
            return;
        }
        switch (MemoryUtil.getCurrentlyWorking(maid)) {
            case PLACE: {
                if (!Conditions.shouldStopAndPickUpItems(maid)) break;
                event.setCanceled(true);
                break;
            }
            case VIEW: 
            case NO_SCHEDULE: 
            case RESORT: 
            case SORTING: 
            case MEAL: {
                break;
            }
            case CO_WORK: {
                if (!event.isSimulate()) break;
                event.setCanceled(true);
                break;
            }
            default: {
                event.setCanceled(true);
            }
        }
        if (event.isCanceled()) {
            return;
        }
        if (!maid.m_9236_().f_46443_) {
            CraftBlockOccupyDataProvider.CraftBlockOccupy occupation = CraftBlockOccupyDataProvider.get(maid.m_9236_());
            if (BlockPos.m_121921_((AABB)entityItem.m_20191_().m_82400_(3.5)).anyMatch(occupation::isOccupiedByAny)) {
                event.setCanceled(true);
                return;
            }
        }
        if (entityItem.m_32055_().m_150930_((Item)ItemRegistry.WRITTEN_INVENTORY_LIST.get())) {
            event.setCanceled(true);
            return;
        }
        if (entityItem.m_32055_().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && !maid.m_9236_().f_46443_) {
            int tickCount = maid.m_9236_().m_7654_().m_129921_();
            Integer restartAt = MemoryUtil.getReturnToScheduleAt(maid);
            if (restartAt != null && tickCount < restartAt) {
                event.setCanceled(true);
                return;
            }
            if (!InvUtil.hasAnyFree((IItemHandler)maid.getAvailableInv(false))) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(MaidPickupEvent.ItemResultPost event) {
        if (!event.isSimulate()) {
            ItemStack pickupItem = event.getPickupItem();
            EntityMaid maid = event.getMaid();
            if (!pickupItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && !pickupItem.m_150930_((Item)ItemRegistry.INVENTORY_LIST.get())) {
                MemoryUtil.getPlacingInv(maid).resetVisitedPos();
                if (MemoryUtil.getPlacingInv(maid).hasTarget()) {
                    MemoryUtil.getPlacingInv(maid).clearTarget();
                    MemoryUtil.clearTarget(maid);
                }
                DebugData.sendDebug("Placing Inv Reset(Picking)", new Object[0]);
            }
        }
    }
}

