/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.integration.Integrations;
import studio.fantasyit.maid_storage_manager.integration.create.StockManagerInteract;
import studio.fantasyit.maid_storage_manager.items.HangUpItem;
import studio.fantasyit.maid_storage_manager.menu.FilterMenu;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;

@Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerInteract {
    public static void onPlayerInteract(ServerLevel level, ServerPlayer player, BlockPos pos, Direction clickedFace) {
        @Nullable Target validStorage = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)player, pos, clickedFace);
        if (validStorage == null) {
            return;
        }
        List maidList = level.m_6249_((Entity)player, player.m_20191_().m_82377_(10.0, 10.0, 10.0), entity -> entity instanceof EntityMaid && ((EntityMaid)entity).m_21830_((LivingEntity)player));
        for (Entity eMaid : maidList) {
            EntityMaid maid = (EntityMaid)eMaid;
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get(), (Object)validStorage);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractMaid(InteractMaidEvent event) {
        ServerPlayer sp;
        EntityMaid maid = event.getMaid();
        Player player = event.getPlayer();
        if (Integrations.createStockManager() && StockManagerInteract.onPlayerInteract(player, maid)) {
            event.setCanceled(true);
            return;
        }
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_21205_().m_150930_(Items.f_42612_)) {
            ItemStack mainHandItem = sp.m_21205_();
            int count = sp.m_6144_() ? mainHandItem.m_41613_() : 1;
            int amount = (3 + sp.m_9236_().f_46441_.m_188503_(5) + sp.m_9236_().f_46441_.m_188503_(5)) * count;
            maid.setExperience(maid.getExperience() + amount);
            mainHandItem.m_41774_(count);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractRc(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().f_46443_ || event.getFace() == null) {
            return;
        }
        PlayerInteract.onPlayerInteract((ServerLevel)event.getLevel(), (ServerPlayer)event.getEntity(), event.getPos(), event.getFace());
    }

    @SubscribeEvent
    public static void onPlayerInteractLc(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().f_46443_ || event.getFace() == null) {
            return;
        }
        PlayerInteract.onPlayerInteract((ServerLevel)event.getLevel(), (ServerPlayer)event.getEntity(), event.getPos(), event.getFace());
    }

    @SubscribeEvent
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Entity entity = event.getTarget();
            if (entity instanceof ItemFrame) {
                final ItemFrame ifr = (ItemFrame)entity;
                if (ifr.m_31822_().m_150930_((Item)ItemRegistry.FILTER_LIST.get())) {
                    if (event.getEntity().m_6144_()) {
                        NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new MenuProvider(){

                            public Component m_5446_() {
                                return Component.m_237119_();
                            }

                            @Nullable
                            public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                                return new FilterMenu(i, player, ifr.m_19879_());
                            }
                        }, buffer -> buffer.writeInt(ifr.m_19879_()));
                    }
                    event.setCanceled(true);
                } else {
                    HangUpItem hi;
                    Item item = ifr.m_31822_().m_41720_();
                    if (item instanceof HangUpItem && (hi = (HangUpItem)item).allowClickThrough()) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

