/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.jei;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeCategory;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.integration.jei.GhostIngredientHandler;
import studio.fantasyit.maid_storage_manager.integration.jei.RequestRecipeHandler;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.craft.altar.AltarCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.base.handler.JEIRecipeHandler;
import studio.fantasyit.maid_storage_manager.menu.craft.brewing.BrewingCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.common.JEICommonRecipeHandler;
import studio.fantasyit.maid_storage_manager.menu.craft.crafting_table.CraftingTableCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.furnace.FurnaceCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.smithing.SmithingCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.stone_cutter.JeiStoneCutterRecipeHandler;
import studio.fantasyit.maid_storage_manager.menu.craft.tacz.JEITaczRecipeTransfer;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;

@JeiPlugin
public class Plugin
implements IModPlugin {
    public static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("maid_storage_manager", "jei");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new RequestRecipeHandler());
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new JEICommonRecipeHandler());
        registration.addRecipeTransferHandler(new JEIRecipeHandler(CraftingTableCraftMenu.class, RecipeTypes.CRAFTING, (MenuType)GuiRegistry.CRAFT_GUIDE_MENU_CRAFTING_TABLE.get()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new JEIRecipeHandler(FurnaceCraftMenu.class, RecipeTypes.SMELTING, (MenuType)GuiRegistry.CRAFT_GUIDE_MENU_FURNACE.get()), RecipeTypes.SMELTING);
        registration.addRecipeTransferHandler(new JEIRecipeHandler(BrewingCraftMenu.class, RecipeTypes.BREWING, (MenuType)GuiRegistry.CRAFT_GUIDE_MENU_BREWING.get()), RecipeTypes.BREWING);
        registration.addRecipeTransferHandler(new JEIRecipeHandler(AltarCraftMenu.class, AltarRecipeCategory.ALTAR, (MenuType)GuiRegistry.CRAFT_GUIDE_MENU_ALTAR.get()), AltarRecipeCategory.ALTAR);
        registration.addRecipeTransferHandler(new JEIRecipeHandler(SmithingCraftMenu.class, RecipeTypes.SMITHING, (MenuType)GuiRegistry.CRAFT_GUIDE_MENU_SMITHING.get()), RecipeTypes.SMITHING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new JeiStoneCutterRecipeHandler(), RecipeTypes.STONECUTTING);
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new JEITaczRecipeTransfer());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        Plugin.jeiRuntime = jeiRuntime;
    }
}

