/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class StorageDefineBauble
extends MaidInteractItem
implements IMaidBauble {
    public static String TAG_STORAGES = "storages";
    public static String TAG_MODE = "mode";
    public static final String TAG_STORAGE_DEFINE = "storage_define";

    public StorageDefineBauble() {
        super(new Item.Properties().m_41487_(1));
    }

    public static Mode rollMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_MODE)) {
            tag.m_128359_(TAG_MODE, Mode.APPEND.name());
        }
        Mode newMode = Mode.values()[(Mode.valueOf(tag.m_128461_(TAG_MODE)).ordinal() + 1) % Mode.values().length];
        tag.m_128359_(TAG_MODE, newMode.name());
        stack.m_41751_(tag);
        return newMode;
    }

    public static void rollMode(ItemStack stack, ServerPlayer sender, int value) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_MODE)) {
            tag.m_128359_(TAG_MODE, Mode.APPEND.name());
        }
        int dv = value > 0 ? 1 : Mode.values().length - 1;
        Mode newMode = Mode.values()[(Mode.valueOf(tag.m_128461_(TAG_MODE)).ordinal() + dv) % Mode.values().length];
        tag.m_128359_(TAG_MODE, newMode.name());
        sender.m_213846_((Component)Component.m_237115_((String)("interaction.mode_" + (switch (newMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.APPEND -> "append";
            case Mode.REMOVE -> "remove";
            case Mode.REPLACE -> "replace";
            case Mode.REPLACE_SPEC -> "replace_spec";
        }))));
        stack.m_41751_(tag);
    }

    public static Mode getMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_MODE)) {
            tag.m_128359_(TAG_MODE, Mode.APPEND.name());
        }
        stack.m_41751_(tag);
        return Mode.valueOf(tag.m_128461_(TAG_MODE));
    }

    public static List<Target> getStorages(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_STORAGES)) {
            return List.of();
        }
        ListTag listTag = tag.m_128437_(TAG_STORAGES, 10);
        ArrayList<Target> storages = new ArrayList<Target>();
        for (int i = 0; i < listTag.size(); ++i) {
            storages.add(Target.fromNbt(listTag.m_128728_(i)));
        }
        return storages;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        ServerPlayer serverPlayer;
        Player player;
        if (!context.m_43725_().f_46443_ && (player = context.m_43723_()) instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_6144_()) {
            BlockPos clickedPos = context.m_8083_();
            Direction side = context.m_43719_();
            Target validTarget = MaidStorage.getInstance().isValidTarget((ServerLevel)context.m_43725_(), (LivingEntity)serverPlayer, clickedPos, side);
            if (validTarget != null) {
                ItemStack item = serverPlayer.m_21205_();
                CompoundTag tag = item.m_41784_();
                if (!tag.m_128441_(TAG_STORAGES)) {
                    tag.m_128365_(TAG_STORAGES, (Tag)new ListTag());
                }
                ListTag list = tag.m_128437_(TAG_STORAGES, 10);
                boolean found = false;
                for (int i = 0; i < list.size(); ++i) {
                    Target storage = Target.fromNbt(list.m_128728_(i));
                    if (storage.equals(validTarget)) {
                        list.remove(i);
                        found = true;
                        break;
                    }
                    if (!storage.pos.equals((Object)validTarget.pos)) continue;
                    list.set(i, (Tag)validTarget.toNbt());
                    found = true;
                    break;
                }
                if (!found) {
                    list.add((Object)validTarget.withoutSide().toNbt());
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.m_6225_(context);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        Mode mode = StorageDefineBauble.getMode(itemStack);
        int count = StorageDefineBauble.getStorages(itemStack).size();
        toolTip.add((Component)Component.m_237115_((String)("interaction.mode_" + (switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.APPEND -> "append";
            case Mode.REMOVE -> "remove";
            case Mode.REPLACE -> "replace";
            case Mode.REPLACE_SPEC -> "replace_spec";
        }))));
        toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.storage_define_bauble.count", (Object[])new Object[]{count}));
    }

    public static enum Mode {
        APPEND,
        REMOVE,
        REPLACE,
        REPLACE_SPEC;

    }
}

