/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.stock;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;

public class StockCheckMoveBehavior
extends Behavior<EntityMaid> {
    public StockCheckMoveBehavior() {
        super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT, (MemoryModuleType)InitEntities.TARGET_POS.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        return Conditions.shouldCheckStock(maid);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        Target storage;
        @Nullable Target target = RequestListItem.getStorageBlock(maid.m_21205_());
        Target target2 = storage = target == null ? null : MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, target.getPos(), target.side);
        if (target == null || storage == null) {
            DebugData.sendDebug("[STOCK_CHECK] No target", new Object[0]);
        } else {
            MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
            BlockPos goal = MoveUtil.selectPosForTarget(level, maid, target.pos);
            if (goal == null) {
                DebugData.sendDebug("[STOCK_CHECK] Unavailable target, waiting", new Object[0]);
                return;
            }
            DebugData.sendDebug("[STOCK_CHECK] Return target %s", storage);
            MemoryUtil.setTarget(maid, goal, (float)Config.collectSpeed);
            MemoryUtil.getRequestProgress(maid).setCheckingStock(true);
            MemoryUtil.getRequestProgress(maid).setTarget(storage);
        }
    }
}

