/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.sorting;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StorageVisitLock;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.ISortSlotContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class SortingBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    private ISortSlotContext context = null;
    Target target = null;
    int count = 0;
    private StorageVisitLock.LockContext lock;

    public SortingBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.SORTING) {
            return false;
        }
        if (!MemoryUtil.getSorting(maid).hasTarget()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (Conditions.isWaitingForReturn(maid)) {
            return false;
        }
        return this.context != null && !this.context.isDoneSorting();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        this.lock = StorageVisitLock.DUMMY;
        if (!MemoryUtil.getSorting(maid).hasTarget()) {
            return;
        }
        MemoryUtil.setWorking(maid, true);
        this.target = MemoryUtil.getSorting(maid).getTarget();
        this.context = MaidStorage.getInstance().getStorage(this.target.getType()).onStartSorting(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
            this.context.startSorting();
            this.lock = StorageVisitLock.getWriteLock(this.target);
        }
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.lock.checkAndTryGrantLock()) {
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        if (this.context != null) {
            this.context.tickSorting();
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        this.lock.release();
        MemoryUtil.setWorking(maid, false);
        if (this.context != null) {
            this.context.finish();
        }
        MemoryUtil.getSorting(maid).removeNeedToSorting(this.target);
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

