/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.memory;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class LogisticsMemory
extends AbstractTargetMemory {
    public static Codec<LogisticsMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractTargetMemory.TargetData.CODEC.fieldOf("targetData").forGetter(AbstractTargetMemory::getTargetData), (App)CraftLayer.CODEC.optionalFieldOf("craftGuide").forGetter(LogisticsMemory::getCraftLayerO), (App)CraftLayer.CODEC.optionalFieldOf("result").forGetter(LogisticsMemory::getResultLayerO), (App)ItemStack.f_41582_.fieldOf("currentLogisticsGuideItem").orElse((Object)ItemStack.f_41583_).forGetter(LogisticsMemory::getCurrentLogisticsGuideItem), (App)Codec.INT.fieldOf("next").forGetter(LogisticsMemory::getNext), (App)Codec.STRING.fieldOf("stage").forGetter(LogisticsMemory::getStageName)).apply((Applicative)instance, LogisticsMemory::new));
    CraftLayer craftLayer;
    CraftLayer resultLayer;
    ItemStack currentLogisticsGuideItem;
    int next;
    Stage stage;

    public LogisticsMemory(AbstractTargetMemory.TargetData targetData, Optional<CraftLayer> craftLayer, Optional<CraftLayer> resultLayer, ItemStack currentLogisticsGuideItem, int next, String stage) {
        super(targetData);
        this.craftLayer = craftLayer.orElse(null);
        this.resultLayer = resultLayer.orElse(null);
        this.currentLogisticsGuideItem = currentLogisticsGuideItem;
        this.next = next;
        this.stage = Stage.valueOf(stage);
    }

    public LogisticsMemory() {
        this.craftLayer = null;
        this.resultLayer = null;
        this.currentLogisticsGuideItem = ItemStack.f_41583_;
        this.next = 0;
        this.stage = Stage.FINISH;
    }

    public Optional<CraftLayer> getCraftLayerO() {
        return Optional.ofNullable(this.craftLayer);
    }

    public Optional<CraftLayer> getResultLayerO() {
        return Optional.ofNullable(this.resultLayer);
    }

    public CraftLayer getCraftLayer() {
        return this.craftLayer;
    }

    public CraftLayer getResultLayer() {
        return this.resultLayer;
    }

    public void setCraftAndResultLayer(CraftLayer craftLayer, CraftLayer resultLayer) {
        this.craftLayer = craftLayer;
        this.resultLayer = resultLayer;
    }

    public ItemStack getCurrentLogisticsGuideItem() {
        return this.currentLogisticsGuideItem;
    }

    public void setCurrentLogisticsGuideItem(ItemStack itemStack) {
        this.currentLogisticsGuideItem = itemStack;
    }

    public void switchCurrentLogisticsGuideItem(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            this.next = (this.next + 1) % maidBauble.getSlots();
            ItemStack stack = maidBauble.getStackInSlot(this.next);
            if (!stack.m_150930_((Item)ItemRegistry.LOGISTICS_GUIDE.get())) continue;
            this.setCurrentLogisticsGuideItem(stack);
            return;
        }
        this.setCurrentLogisticsGuideItem(ItemStack.f_41583_);
    }

    public boolean isStillValid(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        if (this.next >= maidBauble.getSlots()) {
            return false;
        }
        ItemStack stackInSlot = maidBauble.getStackInSlot(this.next);
        return ItemStackUtil.isSame(stackInSlot, this.currentLogisticsGuideItem, true);
    }

    public int getNext() {
        return this.next;
    }

    public boolean shouldWork() {
        return !this.currentLogisticsGuideItem.m_41619_();
    }

    public String getStageName() {
        return this.stage.name();
    }

    public void setStage(Stage stage) {
        if (stage != this.stage) {
            DebugData.sendDebug("[LOGISTIC]Stage change to " + stage.name(), new Object[0]);
        }
        this.stage = stage;
    }

    public Stage getStage() {
        return this.stage;
    }

    public boolean hasMultipleGuide(EntityMaid maid) {
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        int count = 0;
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            ItemStack stack = maidBauble.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemRegistry.LOGISTICS_GUIDE.get())) continue;
            ++count;
        }
        return count > 1;
    }

    public static enum Stage {
        INPUT,
        CRAFT,
        OUTPUT,
        RECYCLE,
        FINISH;

    }
}

