/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.brewing;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class BrewingCraftMenu
extends AbstractCraftMenu<BrewingCraftMenu> {
    public BrewingCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_BREWING.get(), p_38852_, player);
    }

    @Override
    protected void addFilterSlots() {
        int i = 0;
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 35, 65, true));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 79, 72));
        this.setSlotFilter(i - 1, BrewingRecipeRegistry::isValidInput);
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 61, 29));
        this.setSlotFilter(i - 1, BrewingRecipeRegistry::isValidIngredient);
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 124, 72, true));
    }

    @Override
    protected void addSpecialSlots() {
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(0), this.stepDataContainer));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(1), this.stepDataContainer));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(2), this.stepDataContainer));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(3), this.stepDataContainer));
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ALL_INPUT: {
                ListTag list = data.m_128437_("inputs", 10);
                int dIndex = 0;
                if (list.size() > 3) {
                    dIndex = 2;
                }
                for (int i = dIndex; i < list.size(); ++i) {
                    ItemStack stack = ItemStackUtil.parseStack(list.m_128728_(i));
                    this.stepDataContainer.setItemNoTrigger(i + 1 - dIndex, stack);
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
                break;
            }
            case COUNT: {
                this.stepDataContainer.setCount(key, value);
                this.stepDataContainer.m_6596_();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        this.stepDataContainer.setItemNoTrigger(0, Items.f_42593_.m_7968_());
        ItemStack i1 = this.stepDataContainer.m_8020_(1);
        ItemStack i2 = this.stepDataContainer.m_8020_(2);
        Optional<IBrewingRecipe> recipe = RecipeUtil.getBrewingRecipe(this.player.m_9236_(), i1, i2);
        recipe.ifPresentOrElse(craftingRecipe -> {
            ItemStack resultItem = craftingRecipe.getOutput(i1, i2);
            this.stepDataContainer.setItemNoTrigger(3, resultItem);
            this.stepDataContainer.setCount(3, resultItem.m_41613_() * this.stepDataContainer.getCount(1));
        }, () -> this.stepDataContainer.setItemNoTrigger(3, ItemStack.f_41583_));
    }
}

