/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class StorageVisitLock {
    public static final Map<Target, Integer> readLockCounter = new ConcurrentHashMap<Target, Integer>();
    public static final Map<Target, Boolean> writeLockCounter = new ConcurrentHashMap<Target, Boolean>();
    public static final Map<Target, Boolean> writeLockWaiting = new ConcurrentHashMap<Target, Boolean>();
    public static final LockContext DUMMY = new LockContext(false, Target.virtual(BlockPos.f_121853_, null)){

        @Override
        public boolean checkAndTryGrantLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    };

    public static LockContext getReadLock(Target target) {
        return new LockContext(false, target);
    }

    public static LockContext getWriteLock(Target target) {
        return new LockContext(true, target);
    }

    public static synchronized boolean lockRead(Target pos) {
        if (writeLockCounter.getOrDefault(pos, false).booleanValue()) {
            return false;
        }
        if (writeLockWaiting.getOrDefault(pos, false).booleanValue()) {
            return false;
        }
        readLockCounter.put(pos, readLockCounter.getOrDefault(pos, 0) + 1);
        return true;
    }

    public static synchronized void unlockRead(Target pos) {
        if (readLockCounter.getOrDefault(pos, 0) <= 0) {
            throw new IllegalStateException("Trying to unlock a read lock that is not locked");
        }
        readLockCounter.put(pos, readLockCounter.getOrDefault(pos, 0) - 1);
    }

    public static synchronized boolean lockWrite(Target pos) {
        if (writeLockWaiting.getOrDefault(pos, false).booleanValue()) {
            return false;
        }
        if (readLockCounter.getOrDefault(pos, 0) > 0) {
            writeLockWaiting.put(pos, true);
            return false;
        }
        if (writeLockWaiting.getOrDefault(pos, false).booleanValue()) {
            writeLockWaiting.put(pos, false);
        }
        writeLockCounter.put(pos, true);
        return true;
    }

    public static synchronized void unlockWrite(Target pos) {
        if (!writeLockCounter.get(pos).booleanValue()) {
            throw new IllegalStateException("Trying to unlock a write lock that is not locked");
        }
        writeLockCounter.put(pos, false);
    }

    public static class LockContext {
        boolean granted;
        final boolean isWriteLock;
        final Target target;

        public LockContext(boolean isWriteLock, Target target) {
            this.isWriteLock = isWriteLock;
            this.target = target;
            this.tryGrantLock();
        }

        private void tryGrantLock() {
            if (this.granted) {
                return;
            }
            this.granted = this.isWriteLock ? StorageVisitLock.lockWrite(this.target) : StorageVisitLock.lockRead(this.target);
        }

        public boolean checkAndTryGrantLock() {
            if (this.granted) {
                return true;
            }
            this.tryGrantLock();
            return this.granted;
        }

        public void release() {
            if (this.granted) {
                if (this.isWriteLock) {
                    StorageVisitLock.unlockWrite(this.target);
                } else {
                    StorageVisitLock.unlockRead(this.target);
                }
            }
        }
    }
}

