/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.config.subconfig.TaskConfig;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.inventory.tooltip.AmountTooltip;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class RecButton
extends StateSwitchingButton
implements ITooltipButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmsoulkitchen", "textures/gui/cook_guide.png");
    private final EntityMaid maid;
    private final ICookTask<?, ?> cookTask;
    private final CookData cookData;
    private final Recipe<?> recipe;
    private final ItemStack stack;

    public RecButton(EntityMaid maid, ICookTask<?, ?> cookTask, CookData cookData, Recipe<?> recipe, int pX, int pY) {
        super(pX, pY, 20, 20, cookData.recs().contains(recipe.m_6423_().toString()));
        this.m_94624_(179, 25, 22, 0, TEXTURE);
        this.maid = maid;
        this.cookTask = cookTask;
        this.recipe = recipe;
        this.cookData = cookData;
        this.stack = cookTask.getResultItem(recipe, Minecraft.m_91087_().f_91073_.m_9598_());
    }

    public void toggleState() {
        this.f_94609_ = !this.f_94609_;
        this.f_93623_ = true;
    }

    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280480_(this.stack, this.m_252754_() + 2, this.m_252907_() + 2);
        this.renderShadow(pGuiGraphics);
    }

    private void renderShadow(GuiGraphics graphics) {
        if (this.cookData.mode().equals(CookData.Mode.SELECT.name)) {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 20, this.m_252907_() + 20, 1358559737);
        } else {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 20, this.m_252907_() + 20, 0x50000000);
        }
    }

    public boolean isTooltipHovered() {
        return this.m_274382_();
    }

    public void renderTooltip(GuiGraphics guiGraphics, Minecraft minecraft, int pMouseX, int pMouseY) {
        this.renderItemStackTooltips(minecraft, guiGraphics, pMouseX, pMouseY);
    }

    private void renderItemStackTooltips(Minecraft mc, GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        this.renderTooltipWithImage(this.stack, mc, pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderTooltipWithImage(ItemStack stack, Minecraft mc, GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        List stackTooltip = Screen.m_280152_((Minecraft)mc, (ItemStack)stack);
        boolean modeRandom = !this.cookData.mode().equals(CookData.Mode.SELECT.name);
        boolean overSize = this.cookData.recs().size() >= (Integer)TaskConfig.COOK_SELECTED_RECIPES.get();
        NonNullList<Ingredient> ingres = this.cookTask.getIngredients(this.recipe);
        Optional itemContainerTooltip = ingres.isEmpty() ? Optional.empty() : Optional.of(new AmountTooltip((List<Ingredient>)ingres, modeRandom, overSize));
        pGuiGraphics.m_280677_(mc.f_91062_, stackTooltip, itemContainerTooltip, pMouseX, pMouseY);
    }

    public Recipe<?> getRecipe() {
        return this.recipe;
    }
}

