/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.inventory.container.item;

import com.github.wallev.farmsoulkitchen.init.InitItems;
import com.github.wallev.farmsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.farmsoulkitchen.inventory.container.item.CookBagAbstractContainer;
import com.github.wallev.farmsoulkitchen.item.ItemCulinaryHub;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CookBagContainer
extends CookBagAbstractContainer {
    public static final MenuType<CookBagContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new CookBagContainer(windowId, inv, data.m_130267_()));
    public final Map<BagType, ItemStackHandler> handlers;

    public CookBagContainer(int id, Inventory inventory, ItemStack cookBag) {
        super(TYPE, id, inventory, cookBag);
        this.handlers = ItemCulinaryHub.getContainers(cookBag);
        this.addBagTypeSlots(this.handlers);
    }

    public void m_150399_(int slotId, int button, ClickType clickTypeIn, Player player) {
        if (slotId == 27 + player.m_150109_().f_35977_) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.m_150399_(slotId, button, clickTypeIn, player);
        this.setContainer(slotId - 36, this.handlers);
    }

    protected void setContainer(int slotId, Map<BagType, ItemStackHandler> handlers) {
        for (BagType value : BagType.values()) {
            if (slotId < value.startIndex || slotId >= value.endIndex) continue;
            ItemCulinaryHub.setContainer(this.cookBag, handlers);
            break;
        }
    }

    protected void addBagTypeSlots(Map<BagType, ItemStackHandler> handlers) {
        int yOffset = 23;
        int i = 0;
        ItemStackHandler container = handlers.getOrDefault((Object)BagType.INGREDIENT, new ItemStackHandler(BagType.INGREDIENT.size * 9));
        int i1 = 0;
        while (i1 < BagType.INGREDIENT.size) {
            int col = 0;
            while (col < 9) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)container, i, 8 + col * 18, yOffset){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return super.m_5857_(stack) && stack.m_41720_().m_142095_() && !stack.m_150930_((Item)InitItems.CULINARY_HUB.get());
                    }
                });
                ++col;
                ++i;
            }
            ++i1;
            yOffset += 18;
        }
        yOffset += 11;
        List<BagType> list = Arrays.stream(BagType.values()).skip(1L).toList();
        for (BagType value : list) {
            int j = 0;
            ItemStackHandler container1 = handlers.getOrDefault((Object)value, new ItemStackHandler(value.size * 9));
            int row = 0;
            while (row < value.size) {
                int col = 0;
                while (col < 9) {
                    this.m_38897_((Slot)new SlotItemHandler((IItemHandler)container1, j, 8 + col * 18, yOffset){

                        public boolean m_5857_(@NotNull ItemStack stack) {
                            return super.m_5857_(stack) && stack.m_41720_().m_142095_() && !stack.m_150930_((Item)InitItems.CULINARY_HUB.get());
                        }
                    });
                    ++col;
                    ++j;
                }
                ++row;
                yOffset += 18;
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 36 ? !this.m_38903_(stack2, 36, this.f_38839_.size(), false) : !this.m_38903_(stack2, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            this.setContainer(index, this.handlers);
        }
        return stack1;
    }
}

