/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.BerryData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record ActionBerryFarmRuleMessage(int entityId, ResourceLocation dataKey, String rec) {
    public static void encode(ActionBerryFarmRuleMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130085_(message.dataKey);
        buf.m_130070_(message.rec);
    }

    public static ActionBerryFarmRuleMessage decode(FriendlyByteBuf buf) {
        return new ActionBerryFarmRuleMessage(buf.readInt(), buf.m_130281_(), buf.m_130277_());
    }

    public static void handle(ActionBerryFarmRuleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    TaskDataKey value = TaskDataRegister.getValue((ResourceLocation)message.dataKey);
                    BerryData fruitData = (BerryData)maid.getOrCreateData(value, (Object)new BerryData());
                    fruitData.addOrRemoveRule(message.rec);
                    maid.setAndSyncData(value, (Object)fruitData);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

