/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.task.cook.handler.v2.MaidRecipesManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MaidCookMoveTask<B extends BlockEntity, R extends Recipe<? extends Container>>
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int verticalSearchRange;
    private final ICookTask<B, R> task;
    private final boolean single;
    protected int verticalSearchStart;
    private MaidRecipesManager<R> maidRecipesManager;

    public MaidCookMoveTask(EntityMaid maid, ICookTask<B, R> task) {
        this(maid, task, 0.5f, 2, false);
    }

    public MaidCookMoveTask(EntityMaid maid, ICookTask<B, R> task, MaidRecipesManager<R> maidRecipesManager) {
        this(maid, task, 0.5f, 2, false);
        this.maidRecipesManager = maidRecipesManager;
    }

    public MaidCookMoveTask(EntityMaid maid, ICookTask<B, R> task, float movementSpeed, boolean single) {
        this(maid, task, movementSpeed, 2, single);
    }

    public MaidCookMoveTask(EntityMaid maid, ICookTask<B, R> task, float movementSpeed, int verticalSearchRange, boolean single) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.task = task;
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.single = single;
        this.setMaxCheckRate(120);
    }

    private static void setWalkAndLookTargetMemories(LivingEntity pLivingEntity, BlockPos walkPos, BlockPos lookPos, float pSpeed, int pDistance) {
        pLivingEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(walkPos, pSpeed, pDistance));
        pLivingEntity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(lookPos));
    }

    public MaidRecipesManager<R> getMaidRecipesManager() {
        return this.maidRecipesManager;
    }

    private boolean checkOwnerPos(EntityMaid maid, BlockPos mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.m_269323_() != null && mutableBlockPos.m_203195_((Position)maid.m_269323_().m_20182_(), 8.0);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        this.searchForDestination(worldIn, maid);
    }

    private void processRecipeManager(EntityMaid maid) {
        if (this.maidRecipesManager == null) {
            this.maidRecipesManager = new MaidRecipesManager<R>(maid, this.task, this.single, true);
        } else {
            this.maidRecipesManager.checkAndCreateRecipesIngredients(maid);
        }
    }

    protected boolean shouldMoveTo(ServerLevel worldIn, EntityMaid maid, BlockPos blockPos) {
        BlockEntity blockEntity = worldIn.m_7702_(blockPos);
        if (blockEntity == null) {
            return false;
        }
        if (this.task.isCookBE(blockEntity)) {
            this.processRecipeManager(maid);
            return this.task.shouldMoveTo(worldIn, maid, blockEntity, this.maidRecipesManager);
        }
        return false;
    }

    protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
        return maid.canPathReach(pos);
    }

    private static BlockPos getSearchPos(EntityMaid maid) {
        return maid.m_21536_() ? maid.m_21534_() : maid.m_20183_().m_7495_();
    }

    protected final void searchForDestination(ServerLevel worldIn, EntityMaid maid) {
        BlockPos centrePos = MaidCookMoveTask.getSearchPos(maid);
        int searchRange = (int)maid.m_21535_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.m_122154_((Vec3i)centrePos, x, y + 1, z);
                        if (maid.m_21444_((BlockPos)mutableBlockPos) && this.shouldMoveTo(worldIn, maid, (BlockPos)mutableBlockPos) && this.checkOwnerPos(maid, (BlockPos)mutableBlockPos)) {
                            MaidCookMoveTask.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)mutableBlockPos, (BlockPos)mutableBlockPos, this.movementSpeed, 0);
                            maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker((BlockPos)mutableBlockPos));
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
    }
}

