/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.handler.v2;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.InitItems;
import com.github.wallev.farmsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.farmsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.farmsoulkitchen.task.cook.handler.CookBagInventory;
import com.github.wallev.farmsoulkitchen.task.cook.handler.ICookInventory;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidInventory;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidRecipesManager<T extends Recipe<? extends Container>> {
    private final MaidInventory maidInventory;
    private final ICookTask<?, T> task;
    private final boolean single;
    private String lastTaskRule;
    private List<String> recipeIds;
    private int repeatTimes = 0;
    private List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients = new ArrayList<Pair<List<Integer>, List<List<ItemStack>>>>();
    private List<T> currentRecs = new ArrayList<T>();
    private ICookInventory lastInv;

    public MaidRecipesManager(EntityMaid maid, ICookTask<?, T> task, boolean single) {
        this(maid, task, single, false);
    }

    public MaidRecipesManager(EntityMaid maid, ICookTask<?, T> task, boolean single, boolean createRecIng) {
        this.maidInventory = new MaidInventory(maid);
        this.single = single;
        this.task = task;
        this.getIngredientInv(maid);
        if (createRecIng) {
            this.initTaskData(maid);
            this.createRecipesIngredients(maid);
        }
    }

    private static void tranCookBag2Chest(EntityMaid maid, BagType bagType) {
        ItemStackHandler maidInv = maid.getMaidInv();
        ItemStack stackInSlot1 = maidInv.getStackInSlot(4);
        if (!stackInSlot1.m_150930_((Item)InitItems.CULINARY_HUB.get())) {
            return;
        }
        List<BlockPos> ingredientPos = ItemCulinaryHub.getBindModePoses(stackInSlot1, bagType.name);
        if (ingredientPos.isEmpty()) {
            return;
        }
        Map<BagType, ItemStackHandler> containers = ItemCulinaryHub.getContainers(stackInSlot1);
        if (!containers.containsKey((Object)bagType)) {
            return;
        }
        ItemStackHandler itemStackHandler = containers.get((Object)bagType);
        block0: for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            ItemStack stack = itemStackHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            block1: for (BlockPos ingredientPo : ingredientPos) {
                BlockEntity blockEntity = maid.f_19853_.m_7702_(ingredientPo);
                if (stack.m_41619_()) continue block0;
                if (blockEntity == null) continue;
                for (IChestType type : ChestManager.getAllChestTypes()) {
                    if (!type.isChest(blockEntity) || type.getOpenCount((BlockGetter)maid.f_19853_, ingredientPo, blockEntity) > 0) continue;
                    blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(beInv -> {
                        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)beInv, (ItemStack)stack.m_41777_(), (boolean)false);
                        stack.m_41774_(stack.m_41613_() - leftStack.m_41613_());
                    });
                    continue block1;
                }
            }
        }
        ItemCulinaryHub.setContainer(stackInSlot1, containers);
    }

    public boolean isSingle() {
        return this.single;
    }

    public MaidInventory getMaidInventory() {
        return this.maidInventory;
    }

    private List<T> getRecs(EntityMaid maid) {
        Level level = this.maidInventory.getMaid().m_9236_();
        List<Object> allRecipesFor = CookData.Mode.SELECT.name.equals(this.lastTaskRule) ? this.task.getRecipes(level).stream().filter(r -> this.recipeIds.contains(r.m_6423_().toString())).toList() : this.task.getRecipes(level);
        allRecipesFor = new ArrayList<T>(allRecipesFor);
        allRecipesFor = this.filterRecipes(allRecipesFor);
        this.shuffle(allRecipesFor);
        return allRecipesFor;
    }

    public List<Pair<List<Integer>, List<List<ItemStack>>>> getRecipesIngredients() {
        return this.recipesIngredients;
    }

    public Pair<List<Integer>, List<List<ItemStack>>> getRecipeIngredient() {
        if (this.recipesIngredients.isEmpty()) {
            return null;
        }
        int size = this.recipesIngredients.size();
        Pair<List<Integer>, List<List<ItemStack>>> integerListPair = this.recipesIngredients.get(0);
        List<Pair<List<Integer>, List<List<ItemStack>>>> pairs = this.recipesIngredients.subList(1, size);
        this.recipesIngredients = pairs;
        return integerListPair;
    }

    public void checkAndCreateRecipesIngredients(EntityMaid maid) {
        this.initTaskData(maid);
        if (!this.recipesIngredients.isEmpty()) {
            return;
        }
        boolean lastInv = this.isLastInv(maid);
        this.createRecipesIngredients(maid);
    }

    private void initTaskData(EntityMaid maid) {
        if (this.lastTaskRule == null || this.recipeIds == null) {
            ICookTask cookTask = (ICookTask)maid.getTask();
            CookData cookData = (CookData)cookTask.getTaskData(maid);
            this.lastTaskRule = cookData.mode();
            this.recipeIds = cookData.recs();
        }
    }

    private boolean isLastInv(EntityMaid maid) {
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        List<ItemStack> lastInvStack = this.maidInventory.getLastInvStack();
        if (availableInv.getSlots() != lastInvStack.size()) {
            return false;
        }
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack cacheStack;
            ItemStack stackInSlot = availableInv.getStackInSlot(i);
            if (stackInSlot.m_150930_((cacheStack = lastInvStack.get(i)).m_41720_()) && stackInSlot.m_41613_() == cacheStack.m_41613_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItemStack(Item item) {
        Map<Item, List<ItemStack>> inventoryStack = this.maidInventory.getInventoryStack();
        List<ItemStack> itemStacks = inventoryStack.get(item);
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.m_41619_()) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected List<T> filterRecipes(List<T> recipes) {
        return recipes;
    }

    public void mapChestIngredient(EntityMaid maid) {
        BlockEntity blockEntity;
        ItemStackHandler maidInv = maid.getMaidInv();
        ItemStack stackInSlot1 = maidInv.getStackInSlot(4);
        if (!stackInSlot1.m_150930_((Item)InitItems.CULINARY_HUB.get())) {
            return;
        }
        List<BlockPos> ingredientPos = ItemCulinaryHub.getBindModePoses(stackInSlot1, BagType.INGREDIENT.name);
        if (ingredientPos.isEmpty()) {
            return;
        }
        Map<BagType, ItemStackHandler> containers = ItemCulinaryHub.getContainers(stackInSlot1);
        if (!containers.containsKey((Object)BagType.INGREDIENT)) {
            return;
        }
        ItemStackHandler inventory = containers.get((Object)BagType.INGREDIENT);
        ServerLevel level = (ServerLevel)maid.f_19853_;
        ArrayList<Pair> _make = new ArrayList<Pair>();
        HashMap<Item, Integer> available = new HashMap<Item, Integer>();
        HashMap ingredientAmount = new HashMap();
        block0: for (BlockPos ingredientPo : ingredientPos) {
            blockEntity = level.m_7702_(ingredientPo);
            if (blockEntity == null) continue;
            for (IChestType type : ChestManager.getAllChestTypes()) {
                if (!type.isChest(blockEntity) || type.getOpenCount((BlockGetter)maid.f_19853_, ingredientPo, blockEntity) > 0) continue;
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(beInv -> {
                    for (int i = 0; i < beInv.getSlots(); ++i) {
                        ItemStack stackInSlot = beInv.getStackInSlot(i);
                        Item item = stackInSlot.m_41720_();
                        if (stackInSlot.m_41619_()) continue;
                        available.merge(item, stackInSlot.m_41613_(), Integer::sum);
                        List itemStacks = (List)ingredientAmount.get(item);
                        if (itemStacks == null) {
                            ingredientAmount.put(item, Lists.newArrayList((Object[])new ItemStack[]{stackInSlot}));
                            continue;
                        }
                        itemStacks.add(stackInSlot);
                    }
                });
                continue block0;
            }
        }
        for (Recipe t : this.currentRecs) {
            Pair<List<Integer>, List<Item>> maxCount = this.getAmountIngredient(t, available);
            if (((List)maxCount.getFirst()).isEmpty()) continue;
            _make.add(Pair.of((Object)((List)maxCount.getFirst()), (Object)((List)maxCount.getSecond())));
        }
        for (Pair listListPair : _make) {
            List first = (List)listListPair.getFirst();
            List second = (List)listListPair.getSecond();
            block4: for (int i = 0; i < first.size(); ++i) {
                Integer i1 = (Integer)first.get(i);
                Item item = (Item)second.get(i);
                List itemStacks = (List)ingredientAmount.get(item);
                for (ItemStack itemStack : itemStacks) {
                    if (itemStack.m_41619_()) continue;
                    int count = itemStack.m_41613_();
                    if (i1 - count <= 0) {
                        ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)itemStack.m_41620_(i1.intValue()), (boolean)false);
                        continue block4;
                    }
                    ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)itemStack, (boolean)false);
                    i1 = i1 - count;
                }
            }
        }
        for (BlockPos ingredientPo : ingredientPos) {
            blockEntity = level.m_7702_(ingredientPo);
            if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).isPresent()) continue;
            blockEntity.m_6596_();
        }
        ItemCulinaryHub.setContainer(stackInSlot1, containers);
    }

    private void createRecipesIngredients(EntityMaid maid) {
        if (this.lastTaskRule == null || this.recipeIds == null) {
            return;
        }
        this.currentRecs = this.getRecs(maid);
        this.tranUnIngre2Chest(maid);
        this.mapChestIngredient(maid);
        this.maidInventory.refreshInv();
        this.createIngres(maid);
        this.currentRecs.clear();
    }

    public void tranOutput2Chest(EntityMaid maid) {
        MaidRecipesManager.tranCookBag2Chest(maid, BagType.OUTPUT);
    }

    public void tranUnIngre2Chest(EntityMaid maid) {
        MaidRecipesManager.tranCookBag2Chest(maid, BagType.INGREDIENT);
    }

    private void createIngres(EntityMaid maid) {
        ArrayList<Pair<List<Integer>, List<Item>>> _make = new ArrayList<Pair<List<Integer>, List<Item>>>();
        HashMap<Item, Integer> available = new HashMap<Item, Integer>(this.getIngredientInv(maid).getInventoryItem());
        for (Recipe t : this.currentRecs) {
            Pair<List<Integer>, List<Item>> maxCount = this.getAmountIngredient(t, available);
            if (((List)maxCount.getFirst()).isEmpty()) continue;
            _make.add((Pair<List<Integer>, List<Item>>)Pair.of((Object)((List)maxCount.getFirst()), (Object)((List)maxCount.getSecond())));
        }
        this.repeat(_make, available, this.repeatTimes);
        this.recipesIngredients = this.transform(maid, _make, available);
    }

    public ICookInventory getIngredientInv(EntityMaid maid) {
        ItemStackHandler maidInv = maid.getMaidInv();
        ItemStack stackInSlot1 = maidInv.getStackInSlot(4);
        if (!stackInSlot1.m_150930_((Item)InitItems.CULINARY_HUB.get())) {
            this.setLastInv(this.maidInventory);
        } else {
            this.setLastInv(new CookBagInventory(stackInSlot1));
        }
        return this.getLastInv();
    }

    public ICookInventory getLastInv() {
        return this.lastInv;
    }

    private void setLastInv(ICookInventory lastInv) {
        this.lastInv = lastInv;
    }

    protected void repeat(List<Pair<List<Integer>, List<Item>>> oriList, Map<Item, Integer> available, int times) {
        ArrayList<Pair<List<Integer>, List<Item>>> oriPairs = new ArrayList<Pair<List<Integer>, List<Item>>>(oriList);
        for (int l = 0; l < times; ++l) {
            for (Pair<List<Integer>, List<Item>> listListPair : oriPairs) {
                int i;
                List first = (List)listListPair.getFirst();
                List second = (List)listListPair.getSecond();
                boolean canRepeat = true;
                for (i = 0; i < second.size(); ++i) {
                    Integer availableCount = available.get(second.get(i));
                    if (availableCount >= (Integer)first.get(i)) continue;
                    canRepeat = false;
                    break;
                }
                if (!canRepeat) continue;
                for (i = 0; i < second.size(); ++i) {
                    Item item = (Item)second.get(i);
                    available.put(item, available.get(item) - (Integer)first.get(i));
                }
                oriList.add(listListPair);
            }
        }
    }

    protected List<Pair<List<Integer>, List<List<ItemStack>>>> transform(EntityMaid maid, List<Pair<List<Integer>, List<Item>>> oriList, Map<Item, Integer> available) {
        Map<Item, List<ItemStack>> inventoryStack = this.getIngredientInv(maid).getInventoryStack();
        List<Pair<List<Integer>, List<List<ItemStack>>>> list1 = oriList.stream().map(p -> {
            List<List> list = ((List)p.getSecond()).stream().map(item -> (List)inventoryStack.get(item)).toList();
            return Pair.of((Object)((List)p.getFirst()), list);
        }).toList();
        return list1;
    }

    protected Pair<List<Integer>, List<Item>> getAmountIngredient(T recipe, Map<Item, Integer> available) {
        NonNullList<Ingredient> ingredients = this.task.getIngredients((Recipe<?>)recipe);
        boolean[] canMake = new boolean[]{true};
        boolean[] single = new boolean[]{false};
        ArrayList<Item> invIngredient = new ArrayList<Item>();
        HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
        this.extraStartRecipe(recipe, available, canMake, single, itemTimes, invIngredient);
        for (Object ingredient : ingredients) {
            boolean hasIngredient = false;
            for (Item item2 : available.keySet()) {
                ItemStack stack = item2.m_7968_();
                if (!ingredient.test(stack)) continue;
                invIngredient.add(item2);
                hasIngredient = true;
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    itemTimes.put(item2, 1);
                    break;
                }
                itemTimes.merge(item2, 1, Integer::sum);
                break;
            }
            if (hasIngredient) continue;
            canMake[0] = false;
            itemTimes.clear();
            invIngredient.clear();
            break;
        }
        this.extraEndRecipe(recipe, available, canMake, single, itemTimes, invIngredient);
        if (!canMake[0] || invIngredient.stream().anyMatch(item -> (Integer)available.get(item) <= 0)) {
            return Pair.of(new ArrayList(), new ArrayList());
        }
        int maxCount = 64;
        if (single[0] || this.single) {
            maxCount = 1;
        } else {
            for (Item item3 : itemTimes.keySet()) {
                maxCount = Math.min(maxCount, item3.m_7968_().m_41741_());
                maxCount = Math.min(maxCount, available.get(item3) / (Integer)itemTimes.get(item3));
            }
        }
        ArrayList<Integer> countList = new ArrayList<Integer>();
        for (Item item4 : invIngredient) {
            countList.add(maxCount);
            available.put(item4, available.get(item4) - maxCount);
        }
        return Pair.of(countList, invIngredient);
    }

    protected boolean extraStartRecipe(T recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        return true;
    }

    protected boolean extraEndRecipe(T recipe, Map<Item, Integer> available, boolean[] single, boolean[] canMake, Map<Item, Integer> itemTimes, List<Item> invIngredient) {
        return true;
    }

    private void shuffle(List<T> recipes) {
        Collections.shuffle(recipes);
    }

    public int getRepeatTimes() {
        return this.repeatTimes;
    }

    public void setRepeatTimes(int repeatTimes) {
        this.repeatTimes = repeatTimes;
    }

    public IItemHandlerModifiable getOutputInv(EntityMaid maid) {
        ItemStackHandler maidInv = maid.getMaidInv();
        ItemStack stackInSlot1 = maidInv.getStackInSlot(4);
        if (!stackInSlot1.m_150930_((Item)InitItems.CULINARY_HUB.get())) {
            return maidInv;
        }
        ICookInventory lastIngredientInv1 = this.getLastInv();
        return lastIngredientInv1.getAvailableInv(maid, BagType.OUTPUT);
    }

    public IItemHandlerModifiable getIngreInv(EntityMaid maid) {
        ItemStackHandler maidInv = maid.getMaidInv();
        ItemStack stackInSlot1 = maidInv.getStackInSlot(4);
        if (!stackInSlot1.m_150930_((Item)InitItems.CULINARY_HUB.get())) {
            return maidInv;
        }
        ICookInventory lastIngredientInv1 = this.getLastInv();
        return lastIngredientInv1.getAvailableInv(maid, BagType.INGREDIENT);
    }
}

