/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.bakery;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.task.cook.handler.v2.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.bakery.IStoveBe;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.TaskLdContainerCook;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.bestate.IFuelBe;
import com.github.wallev.farmsoulkitchen.util.MaidDataUtil;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.satisfy.bakery.block.entity.StoveBlockEntity;
import net.satisfy.bakery.recipe.StoveRecipe;
import net.satisfy.bakery.registry.ObjectRegistry;
import net.satisfy.bakery.registry.RecipeTypeRegistry;

public class TaskDbkStove
extends TaskLdContainerCook<StoveBlockEntity, StoveRecipe> {
    public static final TaskDbkStove INSTANCE = new TaskDbkStove();
    public static final ResourceLocation UID = new ResourceLocation("farmsoulkitchen", "dkb_stove");
    protected static final int FUEL_SLOT = 4;

    protected TaskDbkStove() {
    }

    @Override
    public boolean maidShouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, StoveBlockEntity blockEntity, MaidRecipesManager<StoveRecipe> maidRecipesManager) {
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        Container inventory = this.getContainer(blockEntity);
        ItemStack outputStack = inventory.m_8020_(this.getOutputSlot());
        if (!outputStack.m_41619_()) {
            return true;
        }
        boolean b = this.beInnerCanCook(inventory, blockEntity);
        List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients = maidRecipesManager.getRecipesIngredients();
        if (!b && !recipesIngredients.isEmpty() && this.beHasFuel(blockEntity) || this.maidHasFuel(availableInv, blockEntity)) {
            return true;
        }
        return !b && this.hasInput(inventory);
    }

    protected boolean beHasFuel(StoveBlockEntity blockEntity) {
        return ((IFuelBe)blockEntity).isBurning$tlma() || ((IStoveBe)blockEntity).getTotalBurnTime$tlma(blockEntity.m_8020_(4)) > 0;
    }

    protected boolean maidHasFuel(CombinedInvWrapper availableInv, StoveBlockEntity blockEntity) {
        return MaidDataUtil.findMaidInventoryItemStack(availableInv, itemStack -> ((IStoveBe)blockEntity).getTotalBurnTime$tlma((ItemStack)itemStack) > 0) > -1;
    }

    @Override
    public void maidCookMake(ServerLevel serverLevel, EntityMaid entityMaid, StoveBlockEntity blockEntity, MaidRecipesManager<StoveRecipe> maidRecipesManager) {
        this.tryExtractItem(serverLevel, entityMaid, (BlockEntity)blockEntity, maidRecipesManager);
        if (!this.fuelItemAction(entityMaid, blockEntity)) {
            return;
        }
        this.tryInsertItem(serverLevel, entityMaid, (BlockEntity)blockEntity, maidRecipesManager);
    }

    protected boolean fuelItemAction(EntityMaid entityMaid, StoveBlockEntity blockEntity) {
        ItemStack fuelStack;
        ItemStack item = blockEntity.m_8020_(4);
        if (((IFuelBe)blockEntity).isBurning$tlma() || ((IStoveBe)blockEntity).getTotalBurnTime$tlma(item) > 0) {
            return true;
        }
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        if (!item.m_41619_()) {
            ItemStack copy = item.m_41777_();
            blockEntity.m_6836_(4, ItemStack.f_41583_);
            ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)copy, (boolean)false);
            blockEntity.m_6596_();
        }
        if ((fuelStack = MaidDataUtil.findMaidInventoryStack(availableInv, itemStack -> ((IStoveBe)blockEntity).getTotalBurnTime$tlma((ItemStack)itemStack) > 0)).m_41619_()) {
            return false;
        }
        blockEntity.m_6836_(4, fuelStack.m_41777_());
        fuelStack.m_41764_(0);
        return true;
    }

    @Override
    public boolean isHeated(StoveBlockEntity be) {
        return true;
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public int getInputStartSlot() {
        return 1;
    }

    @Override
    public int getInputSize() {
        return 3;
    }

    @Override
    public Container getContainer(StoveBlockEntity be) {
        return be;
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof StoveBlockEntity;
    }

    @Override
    public RecipeType<StoveRecipe> getRecipeType() {
        return (RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return ((Block)ObjectRegistry.BRICK_STOVE.get()).m_5456_().m_7968_();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.DBK_STOVE;
    }

    public static TaskDbkStove getInstance() {
        return INSTANCE;
    }
}

