/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.farm;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.TaskBookEntryType;
import com.github.wallev.farmsoulkitchen.api.task.IAddonFarmTask;
import com.github.wallev.farmsoulkitchen.api.task.IFakePlayerTask;
import com.github.wallev.farmsoulkitchen.api.task.v1.farm.ICompatFarm;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.FruitData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.inventory.container.maid.FruitFarmConfigContainer;
import com.github.wallev.farmsoulkitchen.task.ai.MaidCompatFarmPlantTask;
import com.github.wallev.farmsoulkitchen.task.ai.MaidCompatFruitMoveTask;
import com.github.wallev.farmsoulkitchen.task.farm.handler.v1.IFarmHandlerManager;
import com.github.wallev.farmsoulkitchen.task.farm.handler.v1.fruit.FruitHandler;
import com.github.wallev.farmsoulkitchen.task.farm.handler.v1.fruit.FruitHandlerManager;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;

public class TaskFruitFarm
implements ICompatFarm<FruitHandler, FruitData>,
IFakePlayerTask,
IAddonFarmTask {
    public static final TaskFruitFarm INSTANCE = new TaskFruitFarm();
    public static final ResourceLocation UID = new ResourceLocation("farmsoulkitchen", "fruit_farm");

    private TaskFruitFarm() {
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Lists.newArrayList();
        }
        MaidCompatFruitMoveTask<FruitHandler> maidFarmMoveTask = new MaidCompatFruitMoveTask<FruitHandler>(maid, this, 0.6f);
        MaidCompatFarmPlantTask<FruitHandler> maidFarmPlantTask = new MaidCompatFarmPlantTask<FruitHandler>(maid, this, maidFarmMoveTask.getCompatFarmHandler());
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidFarmMoveTask), Pair.of((Object)6, maidFarmPlantTask)});
    }

    @Override
    public IFarmHandlerManager<FruitHandler>[] getManagerHandlerValues() {
        return FruitHandlerManager.values();
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, FruitHandler handler) {
        return handler != null && handler.canHarvest(maid, cropPos, cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, FruitHandler handler) {
        this.maidRightClick(maid, cropPos);
    }

    @Override
    public double getCloseEnoughDist() {
        return 6.0;
    }

    @Override
    public FruitData getDefaultData() {
        return new FruitData();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return Items.f_42410_.m_7968_();
    }

    public boolean isEnable(EntityMaid maid) {
        return true;
    }

    @Override
    public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.FRUIT_FARM;
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Fruit Farm Config Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new FruitFarmConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public TaskDataKey<FruitData> getCookDataKey() {
        return RegisterData.FRUIT_FARM;
    }

    public static TaskFruitFarm getInstance() {
        return INSTANCE;
    }
}

