/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.PlayerAttackCache;
import dev.xkmc.l2damagetracker.contents.attack.Stage;
import dev.xkmc.l2damagetracker.contents.attributes.WrappedAttribute;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2damagetracker.init.data.L2DamageTrackerConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="l2damagetracker", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AttackEventHandler {
    private static final Map<Integer, AttackListener> LISTENERS = new TreeMap<Integer, AttackListener>();
    private static final HashMap<UUID, PlayerAttackCache> PLAYER = new HashMap();
    private static final HashMap<UUID, AttackCache> CACHE = new HashMap();

    public static synchronized void register(int priority, AttackListener entry) {
        while (LISTENERS.containsKey(priority)) {
            ++priority;
        }
        LISTENERS.put(priority, entry);
    }

    public static Collection<AttackListener> getListeners() {
        return LISTENERS.values();
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        PlayerAttackCache cache = new PlayerAttackCache();
        PLAYER.put(event.getEntity().m_20148_(), cache);
        ItemStack stack = event.getEntity().m_21205_();
        cache.setupAttackerProfile((LivingEntity)event.getEntity(), stack);
        cache.pushPlayer(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCriticalHitFirst(CriticalHitEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        PlayerAttackCache cache = PLAYER.get(event.getEntity().m_20148_());
        if (cache == null) {
            cache = new PlayerAttackCache();
        }
        PLAYER.put(event.getTarget().m_20148_(), cache);
        cache.pushCrit(event);
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity2).m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            double cr = ((WrappedAttribute)((Object)L2DamageTracker.CRIT_RATE.get())).getWrappedValue((LivingEntity)player);
            double cd = ((WrappedAttribute)((Object)L2DamageTracker.CRIT_DMG.get())).getWrappedValue((LivingEntity)player);
            double strength = ((WrappedAttribute)((Object)L2DamageTracker.BOW_STRENGTH.get())).getWrappedValue((LivingEntity)player);
            if (arrow.m_36792_() && player.m_217043_().m_188500_() < cr) {
                strength *= 1.0 + cd;
            }
            arrow.m_36781_((double)((float)(arrow.m_36789_() * strength)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackPre(LivingAttackEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (CACHE.size() > 1000) {
            L2DamageTracker.LOGGER.error("attack cache too large: " + CACHE.size());
            CACHE.clear();
            return;
        }
        UUID id = event.getEntity().m_20148_();
        AttackCache cache = CACHE.get(id);
        if (cache != null && (cache.getStage() == Stage.ACTUALLY_HURT_PRE || cache.getStage() == Stage.HURT_PRE)) {
            ++cache.recursive;
            if (((Boolean)L2DamageTrackerConfig.COMMON.enableCyclicDamageEventInterrupt.get()).booleanValue() && cache.recursive >= (Integer)L2DamageTrackerConfig.COMMON.cyclicDamageThreshold.get()) {
                L2DamageTracker.LOGGER.error("Cyclic Damage Event Detected");
                L2DamageTracker.LOGGER.throwing(Level.ERROR, (Throwable)new IllegalStateException("Cyclic Damage Event Detected"));
                event.setCanceled(true);
            }
            return;
        }
        boolean replace = cache == null;
        PlayerAttackCache prev = null;
        if (!replace) {
            replace = cache.getStage().ordinal() >= Stage.HURT_PRE.ordinal();
        }
        Entity attacker = event.getSource().m_7639_();
        if (!replace && attacker != null && PLAYER.containsKey(attacker.m_20148_())) {
            prev = PLAYER.get(attacker.m_20148_());
        }
        if (replace) {
            cache = new AttackCache();
            CACHE.put(id, cache);
        }
        if (prev != null) {
            cache.setupPlayer(prev);
        }
        cache.pushAttackPre(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onAttackPost(LivingAttackEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null) {
            if ((cache.getStage() == Stage.ACTUALLY_HURT_PRE || cache.getStage() == Stage.HURT_PRE) && cache.recursive > 0) {
                --cache.recursive;
                return;
            }
            cache.pushAttackPost(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onActuallyHurtPre(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.HURT_POST) {
            cache.pushHurtPre(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onActuallyHurtPost(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.ACTUALLY_HURT_PRE) {
            cache.pushHurtPost(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDamagePost(LivingDamageEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.ACTUALLY_HURT_POST) {
            cache.pushDamagePre(event);
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        CACHE.clear();
        PLAYER.clear();
    }

    @Nullable
    public static DamageSource onDamageSourceCreate(CreateSourceEvent event) {
        if (event.getAttacker().m_9236_().m_5776_()) {
            return null;
        }
        PlayerAttackCache cache = null;
        if (PLAYER.containsKey(event.getAttacker().m_20148_())) {
            cache = PLAYER.get(event.getAttacker().m_20148_());
        }
        if (cache != null) {
            event.setPlayerAttackCache(cache);
        }
        AttackEventHandler.getListeners().forEach(e -> e.onCreateSource(event));
        if (event.getPlayerAttackCache() != cache) {
            PLAYER.put(event.getAttacker().m_20148_(), event.getPlayerAttackCache());
        }
        if (event.getResult() == null) {
            return null;
        }
        return new DamageSource((Holder)event.getRegistry().m_246971_(event.getResult().type()), event.getDirect(), (Entity)event.getAttacker());
    }
}

