/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.attack;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xkmc.l2damagetracker.init.data.L2DamageTrackerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class LogHelper {
    private static final Map<Key, Val> MAP = new HashMap<Key, Val>();
    private static final Val NULL = new Val(0L, "", null);

    public static boolean savePlayerHurt(ServerPlayer player) {
        if (((Boolean)L2DamageTrackerConfig.COMMON.savePlayerHurt.get()).booleanValue()) {
            return true;
        }
        return MAP.getOrDefault(new Key(Type.HURT, player.m_20148_()), NULL).time() > LogHelper.time(player);
    }

    public static boolean savePlayerAttack(ServerPlayer player) {
        if (((Boolean)L2DamageTrackerConfig.COMMON.savePlayerAttack.get()).booleanValue()) {
            return true;
        }
        return MAP.getOrDefault(new Key(Type.ATTACK, player.m_20148_()), NULL).time() > LogHelper.time(player);
    }

    private static long time(ServerPlayer player) {
        return player.f_8924_.m_129783_().m_46467_();
    }

    public static void buildCommand(LiteralArgumentBuilder<CommandSourceStack> base) {
        ((LiteralArgumentBuilder)base.requires(e -> e.m_6761_(2))).then(Commands.m_82127_((String)"player").then(((RequiredArgumentBuilder)LogHelper.argument("player", EntityArgument.m_91470_()).then(Commands.m_82127_((String)"attack").then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1728000)).executes(ctx -> LogHelper.onStart((CommandContext<CommandSourceStack>)ctx, Type.ATTACK))))).then(Commands.m_82127_((String)"hurt").then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1728000)).executes(ctx -> LogHelper.onStart((CommandContext<CommandSourceStack>)ctx, Type.HURT))))));
    }

    public static void tick(MinecraftServer server) {
        HashMultimap removed = HashMultimap.create();
        MAP.entrySet().removeIf(arg_0 -> LogHelper.lambda$tick$3(server, (Multimap)removed, arg_0));
        for (Map.Entry ent : removed.asMap().entrySet()) {
            String pl = ((Collection)ent.getValue()).size() == 1 ? (String)new ArrayList((Collection)ent.getValue()).get(0) : ((Collection)ent.getValue()).size() + " players";
            ((CommandSource)ent.getKey()).m_213846_((Component)Component.m_237113_((String)("Finished damage profiling for " + pl)));
        }
    }

    private static int onStart(CommandContext<CommandSourceStack> ctx, Type type) throws CommandSyntaxException {
        int time = (Integer)ctx.getArgument("time", Integer.class);
        EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
        List list = sel.m_121166_((CommandSourceStack)ctx.getSource());
        for (ServerPlayer e : list) {
            MAP.put(new Key(type, e.m_20148_()), new Val(e.f_8924_.m_129783_().m_46467_() + (long)time, e.m_6302_(), ((CommandSourceStack)ctx.getSource()).f_81288_));
        }
        int sec = time / 20;
        int min = sec / 60;
        int hrs = min / 60;
        String str = String.format("%02d:%02d:%02d", hrs % 24, min % 60, sec % 60);
        String side = type.name().toLowerCase(Locale.ROOT);
        String pl = list.size() == 1 ? ((ServerPlayer)list.get(0)).m_6302_() : list.size() + " players";
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Start profiling " + side + " of " + pl + " with time " + str)), true);
        return 1;
    }

    protected static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    private static /* synthetic */ boolean lambda$tick$3(MinecraftServer server, Multimap removed, Map.Entry ent) {
        ServerPlayer player = server.m_6846_().m_11259_(((Key)ent.getKey()).uuid());
        if (player == null || ((Val)ent.getValue()).time() < LogHelper.time(player)) {
            removed.put((Object)((Val)ent.getValue()).source(), (Object)((Val)ent.getValue()).playerName());
            return true;
        }
        return false;
    }

    private record Key(Type type, UUID uuid) {
    }

    public static enum Type {
        ATTACK,
        HURT;

    }

    private record Val(long time, String playerName, @Nullable CommandSource source) {
    }
}

