/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.curios;

import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AttrTooltip {
    public static MutableComponent getDesc(Attribute attr, double val, AttributeModifier.Operation op) {
        return AttrTooltip.getDesc(attr, val, op, null, val < 0.0 ^ AttrTooltip.isNegative(attr) ? ChatFormatting.RED : ChatFormatting.BLUE);
    }

    public static MutableComponent getText(Attribute attr, double val, AttributeModifier.Operation op) {
        return AttrTooltip.getDesc(attr, val, op, ChatFormatting.AQUA, ChatFormatting.GRAY);
    }

    public static MutableComponent getDesc(Attribute attr, double val, AttributeModifier.Operation op, @Nullable ChatFormatting num, ChatFormatting all) {
        MutableComponent base;
        MutableComponent text = Component.m_237115_((String)attr.m_22087_());
        if (AttrTooltip.isMult(attr)) {
            if (op == AttributeModifier.Operation.ADDITION) {
                base = Component.m_237113_((String)(val < 0.0 ? "-" : "+"));
                base.m_130946_(ItemStack.f_41584_.format(Math.abs(val * 100.0)));
                base.m_130946_("%");
            } else {
                base = Component.m_237113_((String)"x");
                base.m_130946_(ItemStack.f_41584_.format(val + 1.0));
            }
        } else {
            base = Component.m_237113_((String)(val < 0.0 ? "-" : "+"));
            if (op == AttributeModifier.Operation.ADDITION) {
                base.m_130946_(ItemStack.f_41584_.format(Math.abs(val)));
            } else {
                base.m_130946_(ItemStack.f_41584_.format(Math.abs(val * 100.0)));
                base.m_130946_("%");
            }
        }
        if (num != null) {
            base = Component.m_237119_().m_7220_((Component)base.m_130940_(num));
        }
        base.m_130946_(" ");
        base.m_7220_((Component)text);
        return base.m_130940_(all);
    }

    public static List<Component> modifyTooltip(List<Component> tooltips, Multimap<Attribute, AttributeModifier> attributes, boolean remove) {
        Map<TooltipDetail, Integer> map = AttrTooltip.analyzeTooltip(tooltips);
        for (Map.Entry ent : attributes.entries()) {
            Attribute attr = (Attribute)ent.getKey();
            double val = ((AttributeModifier)ent.getValue()).m_22218_();
            AttributeModifier.Operation op = ((AttributeModifier)ent.getValue()).m_22217_();
            TooltipDetail key = new TooltipDetail(attr.m_22087_(), op.m_22235_());
            Integer index = map.get(key);
            if (index == null) continue;
            map.remove(key);
            if (remove) {
                tooltips.set(index, null);
                continue;
            }
            MutableComponent rep = null;
            if (AttrTooltip.isMult(attr) || AttrTooltip.isNegative(attr)) {
                rep = AttrTooltip.getDesc(attr, val, op);
            }
            if (rep == null) continue;
            tooltips.set(index, (Component)rep);
        }
        tooltips.removeIf(Objects::isNull);
        return tooltips;
    }

    private static Map<TooltipDetail, Integer> analyzeTooltip(List<Component> tooltips) {
        LinkedHashMap<TooltipDetail, Integer> map = new LinkedHashMap<TooltipDetail, Integer>();
        for (int i = 0; i < tooltips.size(); ++i) {
            MutableComponent comp;
            ComponentContents componentContents;
            Object object;
            TranslatableContents tr;
            Object[] args;
            Component txt = tooltips.get(i);
            ComponentContents componentContents2 = txt.m_214077_();
            if (!(componentContents2 instanceof TranslatableContents) || (args = (tr = (TranslatableContents)componentContents2).m_237523_()).length != 2 || !((object = args[1]) instanceof MutableComponent) || !((componentContents = (comp = (MutableComponent)object).m_214077_()) instanceof TranslatableContents)) continue;
            TranslatableContents sub = (TranslatableContents)componentContents;
            int op = tr.m_237508_().charAt(tr.m_237508_().length() - 1) - 48;
            TooltipDetail key = new TooltipDetail(sub.m_237508_(), op);
            if (map.containsKey(key) || op < 0 || op > 2) continue;
            map.put(key, i);
        }
        return map;
    }

    public static boolean isMult(Attribute attr) {
        return ((Holder)ForgeRegistries.ATTRIBUTES.getHolder((Object)attr).orElseThrow()).m_203656_(L2DamageTracker.PERCENTAGE);
    }

    public static boolean isNegative(Attribute attr) {
        return ((Holder)ForgeRegistries.ATTRIBUTES.getHolder((Object)attr).orElseThrow()).m_203656_(L2DamageTracker.NEGATIVE);
    }

    public record TooltipDetail(String id, int op) {
    }
}

