/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.curios;

import dev.xkmc.l2damagetracker.contents.curios.L2Totem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class TotemHelper {
    public static boolean process(LivingEntity self, DamageSource source) {
        for (TotemSlot slot : TotemHelper.totemSlots(self)) {
            L2Totem totem;
            Item item;
            ItemStack holded = slot.stack();
            if (holded.m_41619_() || !((item = holded.m_41720_()) instanceof L2Totem) || !(totem = (L2Totem)item).allow(self, holded, source)) continue;
            if (self instanceof ServerPlayer) {
                InteractionHand interactionHand;
                ServerPlayer serverplayer = (ServerPlayer)self;
                if (slot instanceof HandPred) {
                    HandPred pred = (HandPred)slot;
                    interactionHand = pred.hand();
                } else {
                    interactionHand = InteractionHand.OFF_HAND;
                }
                InteractionHand hand = interactionHand;
                ForgeHooks.onLivingUseTotem((LivingEntity)self, (DamageSource)source, (ItemStack)holded, (InteractionHand)hand);
                serverplayer.m_6278_(Stats.f_12982_.m_12902_((Object)holded.m_41720_()), 1);
                CriteriaTriggers.f_10551_.m_74431_(serverplayer, holded);
            }
            totem.trigger(self, holded, slot, source);
            return true;
        }
        return false;
    }

    public static List<TotemSlot> totemSlots(LivingEntity self) {
        ArrayList<TotemSlot> ans = new ArrayList<TotemSlot>();
        new HandPred(self, self.m_21205_(), InteractionHand.MAIN_HAND).add(ans);
        new HandPred(self, self.m_21206_(), InteractionHand.OFF_HAND).add(ans);
        if (ModList.get().isLoaded("curios")) {
            TotemHelper.curioTotemSlots(self, ans);
        }
        return ans;
    }

    private static void curioTotemSlots(LivingEntity self, List<TotemSlot> ans) {
        LazyOptional opt = CuriosApi.getCuriosInventory((LivingEntity)self);
        if (opt.resolve().isPresent()) {
            ICuriosItemHandler curio = (ICuriosItemHandler)opt.resolve().get();
            for (ICurioStacksHandler handler : curio.getCurios().values()) {
                IDynamicStackHandler stacks = handler.getStacks();
                int n = stacks.getSlots();
                for (int i = 0; i < n; ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    new CurioPred(self, stack, handler.getIdentifier(), i, stacks).add(ans);
                }
            }
        }
    }

    public static interface TotemSlot
    extends Consumer<ItemStack> {
        public LivingEntity user();

        public ItemStack stack();

        default public void add(List<TotemSlot> ans) {
            L2Totem totem;
            Item item = this.stack().m_41720_();
            if (item instanceof L2Totem && (totem = (L2Totem)item).isValid(this.user(), this.stack(), this)) {
                ans.add(this);
            }
        }
    }

    public record HandPred(LivingEntity user, ItemStack stack, InteractionHand hand) implements TotemSlot
    {
        @Override
        public void accept(ItemStack stack) {
            this.user.m_21008_(this.hand, stack);
        }
    }

    public record CurioPred(LivingEntity user, ItemStack stack, String id, int index, IDynamicStackHandler handler) implements TotemSlot
    {
        @Override
        public void accept(ItemStack stack) {
            this.handler.setStackInSlot(this.index, stack);
        }
    }
}

