/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.damage;

import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeVariant;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeWrapper;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;

public class DamageTypeRoot
implements DamageTypeWrapper {
    public static final TreeMap<ResourceKey<DamageType>, DamageTypeRoot> ROOTS = new TreeMap();
    private static final TreeMap<String, GenConfig> GEN = new TreeMap();
    private static boolean generated = false;
    private final String source;
    private final ResourceKey<DamageType> type;
    protected final List<TagKey<DamageType>> inherent;
    protected final Set<DamageState> states;
    protected final Function<DamageTypeWrapper, DamageType> sup;
    private boolean frozen = false;
    private Object2IntArrayMap<DamageState> keys;
    private DamageTypeWrapper[] wrapper;

    public static DamageTypeRoot of(ResourceKey<DamageType> key) {
        return ROOTS.get(key);
    }

    public static synchronized void configureGeneration(Set<String> support, String modid, List<DamageTypeWrapper> list) {
        GEN.put(modid, new GenConfig(support, modid, list));
    }

    public static void generateAll() {
        if (generated) {
            return;
        }
        generated = true;
        for (GenConfig config : GEN.values()) {
            for (DamageTypeRoot val : ROOTS.values()) {
                val.generate(config);
            }
        }
    }

    public DamageTypeRoot(String source, ResourceKey<DamageType> type, List<TagKey<DamageType>> inherent, Function<DamageTypeWrapper, DamageType> sup) {
        this.source = source;
        this.inherent = inherent;
        this.type = type;
        this.states = DamageState.newSet();
        this.sup = sup;
        ROOTS.put(type, this);
    }

    @Override
    public ResourceKey<DamageType> type() {
        return this.type;
    }

    public void add(DamageState state) {
        if (this.frozen) {
            throw new IllegalStateException("Registration already frozen");
        }
        this.states.add(state);
    }

    private void freeze() {
        if (this.frozen) {
            return;
        }
        this.frozen = true;
        int size = 1 << this.states.size();
        this.keys = new Object2IntArrayMap();
        int index = 0;
        for (DamageState state : this.states) {
            this.keys.put((Object)state, index);
            ++index;
        }
        this.wrapper = new DamageTypeWrapper[size];
        this.wrapper[0] = this;
    }

    @Nullable
    protected DamageTypeWrapper get(int index, DamageState state) {
        return this.wrapper[index | 1 << this.keys.getInt((Object)state)];
    }

    protected boolean isEnabled(int index, DamageState state) {
        return (index & 1 << this.keys.getInt((Object)state)) != 0;
    }

    @Override
    public boolean validState(DamageState state) {
        return this.keys.containsKey((Object)state);
    }

    @Override
    public boolean isEnabled(DamageState state) {
        return false;
    }

    @Override
    @Nullable
    public DamageTypeWrapper enable(DamageState state) {
        return this.get(0, state);
    }

    @Override
    public DamageTypeWrapper toRoot() {
        return this;
    }

    @Override
    public DamageType getObject() {
        return this.sup.apply(this);
    }

    @Override
    public Set<DamageState> states() {
        return Set.of();
    }

    public void generate(GenConfig config) {
        this.freeze();
        boolean typeCompatible = config.support().contains(this.source);
        if (!typeCompatible) {
            return;
        }
        ArrayList<DamageState> list = new ArrayList<DamageState>(this.states);
        this.generate(new GenContext(config, DamageState.newSet(), list), Generate.DEFAULT, 0, 0);
    }

    private void generate(GenContext ctx, Generate gen, int key, int i) {
        if (i == ctx.list().size()) {
            boolean shouldGen;
            TreeSet<DamageState> copy = DamageState.newSet();
            copy.addAll(ctx.set());
            DamageTypeVariant ans = new DamageTypeVariant(ctx.config().modid(), this, key, ctx.set());
            boolean bl = shouldGen = gen == Generate.ALLOW;
            if (copy.size() > 0 && ctx.config.modid.equals(this.source)) {
                shouldGen |= gen == Generate.DEFAULT;
            }
            if (shouldGen) {
                ctx.config().gen().add(ans);
                this.wrapper[key] = ans;
            }
            return;
        }
        DamageState st = ctx.list().get(i);
        this.generate(ctx, gen, key, i + 1);
        for (DamageState old : ctx.set()) {
            if (!old.overrides(st) && !st.overrides(old)) continue;
            gen = Generate.DENY;
        }
        boolean stateCompatible = ctx.config().support().contains(st.getId().m_135827_());
        boolean stateOrigin = ctx.config.modid.equals(st.getId().m_135827_());
        boolean typeOrigin = ctx.config.modid.equals(this.source);
        if (!stateCompatible) {
            gen = Generate.DENY;
        }
        if (gen == Generate.DEFAULT && (typeOrigin || stateOrigin)) {
            gen = Generate.ALLOW;
        }
        ctx.set().add(st);
        this.generate(ctx, gen, key | 1 << i, i + 1);
        ctx.set().remove(st);
    }

    record GenConfig(Set<String> support, String modid, List<DamageTypeWrapper> gen) {
    }

    record GenContext(GenConfig config, TreeSet<DamageState> set, List<DamageState> list) {
    }

    static enum Generate {
        DEFAULT,
        DENY,
        ALLOW;

    }
}

