/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.generic;

import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericArmorItem;
import dev.xkmc.l2damagetracker.init.data.ArmorEffectConfig;
import dev.xkmc.l2damagetracker.init.data.L2DTLangData;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ExtraArmorConfig {
    public double repair_chance = 0.0;
    public double damage_chance = 1.0;
    public int magic_immune = 0;

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity) {
        double raw = (double)amount * this.damage_chance;
        int floor = (int)Math.floor(raw);
        double rem = raw - (double)floor;
        return floor + (entity.m_9236_().f_46441_.m_188500_() < rem ? 1 : 0);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (stack.m_41768_() && this.repair_chance > level.m_213780_().m_188500_()) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    public int getMagicImmune() {
        return this.magic_immune;
    }

    public Multimap<Attribute, AttributeModifier> modify(Multimap<Attribute, AttributeModifier> map, EquipmentSlot slot, ItemStack stack) {
        return map;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        String name = ((ArmorItem)stack.m_41720_()).m_40401_().m_6082_();
        ArmorEffectConfig config = ArmorEffectConfig.get();
        if (config == null || !config.isEffectBlocking(name)) {
            return;
        }
        Set<MobEffect> set = ArmorEffectConfig.get().getImmunity(name);
        for (MobEffect e : set) {
            if (!player.m_21023_(e)) continue;
            player.m_21195_(e);
        }
    }

    public ExtraArmorConfig repairChance(double chance) {
        this.repair_chance = chance;
        return this;
    }

    public ExtraArmorConfig damageChance(double chance) {
        this.damage_chance = chance;
        return this;
    }

    public ExtraArmorConfig setMagicImmune(int percent) {
        this.magic_immune = percent;
        return this;
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
        String name = ((ArmorItem)stack.m_41720_()).m_40401_().m_6082_();
        ArmorEffectConfig config = ArmorEffectConfig.get();
        if (config == null || !config.isEffectBlocking(name)) {
            return;
        }
        Set<MobEffect> set = ArmorEffectConfig.get().getImmunity(name);
        TreeMap<ResourceLocation, MobEffect> map = new TreeMap<ResourceLocation, MobEffect>();
        for (MobEffect e : set) {
            map.put(ForgeRegistries.MOB_EFFECTS.getKey((Object)e), e);
        }
        MutableComponent comp = L2DTLangData.ARMOR_IMMUNE.get(new Object[0]);
        boolean comma = false;
        for (MobEffect e : map.values()) {
            if (comma) {
                comp = comp.m_130946_(", ");
            }
            comma = true;
            comp = comp.m_7220_((Component)Component.m_237115_((String)e.m_19481_()).m_130940_(e.m_19483_().m_19497_()));
        }
        list.add((Component)comp.m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    public boolean hideWithEffect() {
        return false;
    }

    public boolean dampenVibration() {
        return false;
    }

    public boolean immuneToEffect(ItemStack stack, GenericArmorItem armor, MobEffectInstance effectInstance) {
        String name = armor.m_40401_().m_6082_();
        ArmorEffectConfig config = ArmorEffectConfig.get();
        if (config == null || !config.isEffectBlocking(name)) {
            return false;
        }
        return ArmorEffectConfig.get().getImmunity(name).contains(effectInstance.m_19544_());
    }
}

