/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.generic;

import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatVanillaType;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.GenItemVanillaType;
import dev.xkmc.l2library.base.effects.EffectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ExtraToolConfig {
    public int tool_hit = 2;
    public int tool_mine = 1;
    public int sword_hit = 1;
    public int sword_mine = 2;
    public double repair_chance = 0.0;
    public double damage_chance = 1.0;
    public boolean canBeDepleted = true;
    public boolean bypassArmor;
    public boolean bypassMagic;
    public List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    public Function<IMatVanillaType, Item> stick = e -> Items.f_42398_;
    public boolean reversed = false;
    public Function<Integer, TagKey<Block>> tier = GenItemVanillaType::getBlockTag;

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity) {
        double raw = (double)amount * this.damage_chance;
        int floor = (int)Math.floor(raw);
        double rem = raw - (double)floor;
        return floor + (entity.m_9236_().f_46441_.m_188500_() < rem ? 1 : 0);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (stack.m_41768_() && this.repair_chance > level.m_213780_().m_188500_()) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    public void onHit(ItemStack stack, LivingEntity target, LivingEntity user) {
        for (MobEffectInstance ins : this.effects) {
            EffectUtil.addEffect((LivingEntity)target, (MobEffectInstance)ins, (EffectUtil.AddReason)EffectUtil.AddReason.NONE, (Entity)user);
        }
    }

    public ExtraToolConfig repairChance(double chance) {
        this.repair_chance = chance;
        return this;
    }

    public ExtraToolConfig damageChance(double chance) {
        this.damage_chance = chance;
        return this;
    }

    public ExtraToolConfig setUnDepletable() {
        this.canBeDepleted = true;
        return this;
    }

    public ExtraToolConfig addEffects(MobEffectInstance ... ins) {
        this.effects.addAll(List.of(ins));
        return this;
    }

    public ExtraToolConfig setBypassArmor() {
        this.bypassArmor = true;
        return this;
    }

    public ExtraToolConfig setBypassMagic() {
        this.bypassMagic = true;
        return this;
    }

    public ExtraToolConfig setStick(Function<IMatVanillaType, Item> sup, boolean reverse) {
        this.stick = sup;
        this.reversed = reverse;
        return this;
    }

    public ExtraToolConfig setTier(Function<Integer, TagKey<Block>> tag) {
        this.tier = tag;
        return this;
    }

    public Multimap<Attribute, AttributeModifier> modify(Multimap<Attribute, AttributeModifier> map, EquipmentSlot slot, ItemStack stack) {
        return map;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state, float old) {
        return old;
    }

    public TagKey<Block> getTier(int level) {
        return this.tier.apply(level);
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
    }

    public boolean hideWithEffect() {
        return false;
    }

    public void onDamage(AttackCache cache, ItemStack stack) {
    }
}

