/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.vanilla;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2damagetracker.contents.materials.api.ArmorConfig;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatVanillaType;
import dev.xkmc.l2damagetracker.contents.materials.api.ITool;
import dev.xkmc.l2damagetracker.contents.materials.api.ToolConfig;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericArmorItem;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.Tools;
import dev.xkmc.l2library.base.L2Registrate;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.Tags;

public record GenItemVanillaType(String modid, L2Registrate registrate) {
    public static final ToolConfig TOOL_GEN = new ToolConfig(GenItemVanillaType::genGenericTool);
    public static final ArmorConfig ARMOR_GEN = new ArmorConfig((mat, slot, prop) -> new GenericArmorItem(mat.getArmorMaterial(), slot, prop, mat.getExtraArmorConfig()));

    public static Item genGenericTool(IMatToolType mat, ITool tool, Item.Properties prop) {
        int dmg = mat.getToolStats().getDamage(tool) - 1;
        float speed = mat.getToolStats().getSpeed(tool) - 4.0f;
        return tool.create(mat.getTier(), dmg, speed, prop, mat.getExtraToolConfig());
    }

    public static TagKey<Block> getBlockTag(int level) {
        return switch (level) {
            case 0 -> Tags.Blocks.NEEDS_WOOD_TOOL;
            case 1 -> BlockTags.f_144286_;
            case 2 -> BlockTags.f_144285_;
            case 3 -> BlockTags.f_144284_;
            default -> Tags.Blocks.NEEDS_NETHERITE_TOOL;
        };
    }

    public ItemEntry<Item>[][] genItem(IMatVanillaType[] mats) {
        int n = mats.length;
        ItemEntry[][] ans = new ItemEntry[n][9];
        for (int i = 0; i < n; ++i) {
            IMatVanillaType mat = mats[i];
            String id = mat.getID();
            BiFunction<String, ArmorItem.Type, ItemBuilder> armor_gen = (str, slot) -> this.registrate.item(id + "_" + str, p -> mat.getArmorConfig().sup().get(mat, (ArmorItem.Type)slot, (Item.Properties)p)).model((ctx, pvd) -> this.generatedModel((DataGenContext)ctx, (RegistrateItemModelProvider)pvd, id, (String)str)).defaultLang();
            ans[i][3] = armor_gen.apply("helmet", ArmorItem.Type.HELMET).tag(new TagKey[]{Tags.Items.ARMORS_HELMETS, ItemTags.f_265942_}).register();
            ans[i][2] = armor_gen.apply("chestplate", ArmorItem.Type.CHESTPLATE).tag(new TagKey[]{Tags.Items.ARMORS_CHESTPLATES, ItemTags.f_265942_}).register();
            ans[i][1] = armor_gen.apply("leggings", ArmorItem.Type.LEGGINGS).tag(new TagKey[]{Tags.Items.ARMORS_LEGGINGS, ItemTags.f_265942_}).register();
            ans[i][0] = armor_gen.apply("boots", ArmorItem.Type.BOOTS).tag(new TagKey[]{Tags.Items.ARMORS_BOOTS, ItemTags.f_265942_}).register();
            BiFunction<String, Tools, ItemEntry> tool_gen = (str, tool) -> this.registrate.item(id + "_" + str, p -> mat.getToolConfig().sup().get(mat, (ITool)tool, (Item.Properties)p)).model((ctx, pvd) -> this.handHeld((DataGenContext)ctx, (RegistrateItemModelProvider)pvd, id, (String)str)).tag(new TagKey[]{tool.tag}).defaultLang().register();
            for (int j = 0; j < Tools.values().length; ++j) {
                Tools tool2 = Tools.values()[j];
                ans[i][4 + j] = tool_gen.apply(tool2.name().toLowerCase(Locale.ROOT), tool2);
            }
        }
        return ans;
    }

    public ItemEntry<Item>[] genMats(IMatVanillaType[] mats, String suffix, TagKey<Item> tag) {
        int n = mats.length;
        ItemEntry[] ans = new ItemEntry[n];
        for (int i = 0; i < n; ++i) {
            String id = mats[i].getID();
            ans[i] = this.registrate.item(id + "_" + suffix, Item::new).model((ctx, pvd) -> this.generatedModel((DataGenContext)ctx, (RegistrateItemModelProvider)pvd, id, suffix)).tag(new TagKey[]{tag}).defaultLang().register();
        }
        return ans;
    }

    public BlockEntry<Block>[] genBlockMats(IMatVanillaType[] mats) {
        int n = mats.length;
        BlockEntry[] ans = new BlockEntry[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = ((BlockBuilder)this.registrate.block(mats[i].getID() + "_block", p -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_))).defaultLoot().defaultBlockstate().tag(new TagKey[]{BlockTags.f_144282_, BlockTags.f_144286_, Tags.Blocks.STORAGE_BLOCKS}).item().tag(new TagKey[]{Tags.Items.STORAGE_BLOCKS}).build()).defaultLang().register();
        }
        return ans;
    }

    public <T extends Item> void generatedModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd, String id, String suf) {
        pvd.generated(ctx, new ResourceLocation[]{new ResourceLocation(this.modid, "item/generated/" + id + "/" + suf)});
    }

    public <T extends Item> void handHeld(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd, String id, String suf) {
        pvd.handheld(ctx, new ResourceLocation(this.modid, "item/generated/" + id + "/" + suf));
    }
}

