/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.contents.materials.vanilla;

import dev.xkmc.l2damagetracker.contents.materials.api.ITool;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericAxeItem;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericHoeItem;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericPickaxeItem;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericShovelItem;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericSwordItem;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.RawToolFactory;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;

public enum Tools implements ITool
{
    SWORD((TagKey<Item>)ItemTags.f_271388_, GenericSwordItem::new, 1.0f, 0.0f, 1.6f),
    AXE((TagKey<Item>)ItemTags.f_271207_, GenericAxeItem::new, 1.4f, 0.0f, 1.0f),
    SHOVEL((TagKey<Item>)ItemTags.f_271138_, GenericShovelItem::new, 0.7f, 0.0f, 1.0f),
    PICKAXE((TagKey<Item>)ItemTags.f_271360_, GenericPickaxeItem::new, 0.7f, 0.0f, 1.2f),
    HOE((TagKey<Item>)ItemTags.f_271298_, GenericHoeItem::new, 0.5f, -5.0f, 4.0f);

    final TagKey<Item> tag;
    private final RawToolFactory fac;
    private final float damage_scale;
    private final float damage_offset;
    private final float speed_scale;

    private Tools(TagKey<Item> tag, RawToolFactory fac, float damage_scale, float damage_offset, float speed_scale) {
        this.tag = tag;
        this.fac = fac;
        this.damage_scale = damage_scale;
        this.damage_offset = damage_offset;
        this.speed_scale = speed_scale;
    }

    @Override
    public int getDamage(int base_damage) {
        return Math.round(((float)base_damage + this.damage_offset) * this.damage_scale);
    }

    @Override
    public float getSpeed(float base_speed) {
        return Mth.m_14036_((float)((float)Math.round(base_speed * this.speed_scale * 10.0f) * 0.1f), (float)0.1f, (float)4.0f);
    }

    @Override
    public Item create(Tier tier, int damage, float speed, Item.Properties prop, ExtraToolConfig config) {
        return this.fac.get(tier, damage, speed, prop, config);
    }
}

