/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.events;

import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.attack.PlayerAttackCache;
import dev.xkmc.l2damagetracker.contents.attributes.WrappedAttribute;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericTieredItem;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import java.util.function.BiConsumer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;

public class GeneralAttackListener
implements AttackListener {
    @Override
    public boolean onCriticalHit(PlayerAttackCache cache, CriticalHitEvent event) {
        Player player = event.getEntity();
        double cr = ((WrappedAttribute)((Object)L2DamageTracker.CRIT_RATE.get())).getWrappedValue((LivingEntity)player);
        double cd = ((WrappedAttribute)((Object)L2DamageTracker.CRIT_DMG.get())).getWrappedValue((LivingEntity)player);
        if (event.isVanillaCritical()) {
            event.setDamageModifier(event.getDamageModifier() / 1.5f * (float)(1.0 + cd));
        } else if (player.m_217043_().m_188500_() < cr) {
            event.setDamageModifier(event.getDamageModifier() * (float)(1.0 + cd));
            event.setResult(Event.Result.ALLOW);
            return true;
        }
        return false;
    }

    @Override
    public void onCreateSource(CreateSourceEvent event) {
        Item item = event.getAttacker().m_21205_().m_41720_();
        if (item instanceof GenericTieredItem) {
            GenericTieredItem gen = (GenericTieredItem)item;
            if (event.getRegistry().m_246971_(event.getOriginal()).m_203656_(L2DamageTypes.MATERIAL_MUX)) {
                ExtraToolConfig config = gen.getExtraConfig();
                if (config.bypassMagic) {
                    event.enable(DefaultDamageState.BYPASS_MAGIC);
                }
                if (config.bypassArmor) {
                    event.enable(DefaultDamageState.BYPASS_ARMOR);
                }
            }
        }
    }

    @Override
    public void setupProfile(AttackCache cache, BiConsumer<LivingEntity, ItemStack> setup) {
        DamageSource source;
        Entity entity;
        if (cache.getLivingAttackEvent() != null && (entity = (source = cache.getLivingAttackEvent().getSource()).m_7639_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (source.m_269533_(L2DamageTypes.DIRECT)) {
                setup.accept(le, le.m_21205_());
            } else {
                setup.accept(le, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void onHurt(AttackCache cache, ItemStack weapon) {
        LivingEntity attacker;
        LivingHurtEvent event = cache.getLivingHurtEvent();
        assert (event != null);
        Item item = weapon.m_41720_();
        if (item instanceof GenericTieredItem) {
            GenericTieredItem item2 = (GenericTieredItem)item;
            item2.getExtraConfig().onDamage(cache, weapon);
        }
        if ((attacker = cache.getAttacker()) != null) {
            if (event.getSource().m_269533_(DamageTypeTags.f_268415_)) {
                cache.addHurtModifier(DamageModifier.multTotal((float)((WrappedAttribute)((Object)L2DamageTracker.EXPLOSION_FACTOR.get())).getWrappedValue(attacker)));
            }
            if (event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                cache.addHurtModifier(DamageModifier.multTotal((float)((WrappedAttribute)((Object)L2DamageTracker.FIRE_FACTOR.get())).getWrappedValue(attacker)));
            }
            if (event.getSource().m_269533_(L2DamageTypes.MAGIC)) {
                cache.addHurtModifier(DamageModifier.multTotal((float)((WrappedAttribute)((Object)L2DamageTracker.MAGIC_FACTOR.get())).getWrappedValue(attacker)));
            }
        }
    }

    @Override
    public void onDamage(AttackCache cache, ItemStack weapon) {
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        if (!event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
            float val;
            AttributeInstance ins = cache.getAttackTarget().m_21051_((Attribute)L2DamageTracker.REDUCTION.get());
            if (ins != null) {
                val = (float)ins.m_22135_();
                cache.addDealtModifier(DamageModifier.multAttr(val));
            }
            if ((ins = cache.getAttackTarget().m_21051_((Attribute)L2DamageTracker.ABSORB.get())) != null) {
                val = (float)ins.m_22135_();
                cache.addDealtModifier(DamageModifier.add(-val));
                cache.addDealtModifier(DamageModifier.nonlinearMiddle(943, e -> Math.max(0.0f, e)));
            }
        }
    }
}

