/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2damagetracker.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class L2DamageTrackerConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        L2DamageTrackerConfig.register(ModConfig.Type.CLIENT, CLIENT_SPEC);
        L2DamageTrackerConfig.register(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    private static void register(ModConfig.Type type, IConfigSpec<?> spec) {
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        String path = "l2_configs/" + mod.getModId() + "-" + type.extension() + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, path);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableCyclicDamageEventInterrupt;
        public final ForgeConfigSpec.IntValue cyclicDamageThreshold;
        public final ForgeConfigSpec.BooleanValue muteCyclicDamageInterrupt;
        public final ForgeConfigSpec.BooleanValue printDamageTrace;
        public final ForgeConfigSpec.BooleanValue savePlayerAttack;
        public final ForgeConfigSpec.BooleanValue savePlayerHurt;

        Common(ForgeConfigSpec.Builder builder) {
            this.enableCyclicDamageEventInterrupt = builder.comment("Allows L2DamageTracker to detect and prevent cyclic damage events").define("enableCyclicDamageEventInterrupt", false);
            this.cyclicDamageThreshold = builder.comment("Cyclic Damage Interruption threshold").defineInRange("cyclicDamageThreshold", 1, 1, 1000);
            this.muteCyclicDamageInterrupt = builder.comment("Mute error log lines for cyclic damage").define("muteCyclicDamageInterrupt", false);
            this.printDamageTrace = builder.comment("Print damage trace tracked by damage tracker").define("printDamageTrace", false);
            this.savePlayerAttack = builder.comment("Save player attack damage trace").define("savePlayerAttack", false);
            this.savePlayerHurt = builder.comment("Save player hurt damage trace").define("savePlayerDamaged", false);
        }
    }
}

