/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.capability;

import io.github.tt432.kitchenkarrot.item.ShakerItem;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import io.github.tt432.kitchenkarrot.tag.ModItemTags;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShakerCapabilityProvider
extends CapabilityProvider<ShakerCapabilityProvider>
implements INBTSerializable<CompoundTag> {
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> new ItemStackHandler(12){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (!stack.m_41720_().m_142095_()) {
                return false;
            }
            return !(stack.m_41720_() instanceof ShakerItem) && (slot < 5 || slot > 10 || (slot < 9 ? stack.m_204117_(ModItemTags.BASE) : (slot == 9 ? stack.m_150930_((Item)ModItems.ICE_CUBES.get()) : stack.m_150930_((Item)ModItems.CARROT_SPICES.get()))));
        }
    });

    public ShakerCapabilityProvider() {
        super(ShakerCapabilityProvider.class);
    }

    public CompoundTag serializeNBT() {
        return ((ItemStackHandler)this.handler.resolve().get()).serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.handler.ifPresent(h -> h.deserializeNBT(nbt));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.handler.cast());
    }
}

