/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModCommonConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON;
    public static ForgeConfigSpec.ConfigValue<Boolean> CAN_ENTITY_SPAWN;
    public static ForgeConfigSpec.ConfigValue<Integer> CAN_ENTITY_LIFETIME;
    public static ForgeConfigSpec.ConfigValue<Boolean> BUTCHER_SELL_SALT;
    public static ForgeConfigSpec.ConfigValue<Boolean> BUTCHER_SELL_OIL;
    public static ForgeConfigSpec.ConfigValue<Boolean> FARMER_BUY_GEM_CARROT;
    public static ForgeConfigSpec.ConfigValue<List<String>> UNKNOWN_COCKTAIL_EFFECTS_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<Boolean> WHITELIST_MODE;
    public static ForgeConfigSpec.ConfigValue<Integer> MAXIMUM_TIPSY_LEVEL;
    public static ForgeConfigSpec.ConfigValue<List<String>> WASTED_EFFECTS_LIST;
    public static ForgeConfigSpec.ConfigValue<List<String>> WASTED_EFFECTS_LEVEL;
    public static ForgeConfigSpec.ConfigValue<Integer> WASTED_DURATION;
    public static final List<String> COCKTAIL_EFFECTS;
    public static final List<String> WASTED_EFFECTS;

    static {
        COCKTAIL_EFFECTS = new ArrayList<String>(List.of("minecraft:instant_health", "minecraft:instant_damage", "minecraft:bad_omen", "minecraft:hero_of_the_village", "kitchenkarrot:disperse"));
        WASTED_EFFECTS = new ArrayList<String>(List.of("minecraft:weakness", "minecraft:slowness", "minecraft:hunger"));
        BUILDER.comment("Common Configs for KitchenKarrot");
        BUILDER.push("Canned Food Settings");
        CAN_ENTITY_SPAWN = BUILDER.comment("Whether an empty can entity spawns everytime player finished eating a canned food.").define("Spawn Empty Can Entity", (Object)Boolean.TRUE);
        CAN_ENTITY_LIFETIME = BUILDER.comment(new String[]{"The maximum time in seconds an empty can entity can live.", "10 by default, -1 to prevent disappearing."}).define("Can Entity Lifetime", (Object)10);
        BUILDER.pop();
        BUILDER.push("Villager Trade Settings");
        BUTCHER_SELL_SALT = BUILDER.comment("Will butcher villager sell salt at level 1.").define("Butcher Sell Salt", (Object)Boolean.TRUE);
        BUTCHER_SELL_OIL = BUILDER.comment("Will butcher villager sell oil at level 1.").define("Butcher Sell Oil", (Object)Boolean.TRUE);
        FARMER_BUY_GEM_CARROT = BUILDER.comment("Will farmer villager buy gem carrot at level 3.").define("Farmer Buy Gem Carrot", (Object)Boolean.TRUE);
        BUILDER.pop();
        BUILDER.push("Cocktail Settings");
        UNKNOWN_COCKTAIL_EFFECTS_BLACKLIST = BUILDER.comment("Unknown cocktail gives a random effect in the game except following.").define("Unknown Cocktail Effects Blacklist", COCKTAIL_EFFECTS);
        WHITELIST_MODE = BUILDER.comment(new String[]{"Turn the blacklist above into a whitelist.Only the given effects will be applied.", "False by default."}).define("Whitelist Mode", (Object)Boolean.FALSE);
        BUILDER.pop();
        BUILDER.push("Alcohol Settings");
        MAXIMUM_TIPSY_LEVEL = BUILDER.comment(new String[]{"Determines the maximum level the tipsy effect can reach. Each level decreases 5% movement speed and increases 5% attack damage.", "Upon reaching anywhere higher than the maximum level will turn the current effects into harmful ones.", "3 by default."}).define("Maximum Tipsy Level", (Object)3);
        WASTED_DURATION = BUILDER.comment(new String[]{"The duration in ticks of the drunk state effects (except nausea).", "1200 ticks (60 seconds) by default."}).define("Wasted State Duration", (Object)1200);
        WASTED_EFFECTS_LIST = BUILDER.comment("The effects to be applied when the entity gets drunk.").define("Wasted State Effects", WASTED_EFFECTS);
        WASTED_EFFECTS_LEVEL = BUILDER.comment("The level of each effect of the drunk state. Each number represents the real level appeared in game. This list should be as long as the previous one.").define("Wasted State Effects Duration", List.of("3", "3", "3"));
        BUILDER.pop();
        COMMON = BUILDER.build();
    }
}

