/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.dependencies.jei;

import io.github.tt432.kitchenkarrot.dependencies.jei.category.AirCompressorRecipeCategory;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.BrewingBarrelRecipeCategory;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.CocktailRecipeCategory;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.CocktailSubtypeInterpreter;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.PlateRecipeCategory;
import io.github.tt432.kitchenkarrot.gui.AirCompressorGui;
import io.github.tt432.kitchenkarrot.gui.BrewingBarrelGui;
import io.github.tt432.kitchenkarrot.gui.ShakerGui;
import io.github.tt432.kitchenkarrot.item.ModBlockItems;
import io.github.tt432.kitchenkarrot.menu.AirCompressorMenu;
import io.github.tt432.kitchenkarrot.menu.BrewingBarrelMenu;
import io.github.tt432.kitchenkarrot.menu.ShakerMenu;
import io.github.tt432.kitchenkarrot.recipes.recipe.AirCompressorRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.BrewingBarrelRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.CocktailRecipe;
import io.github.tt432.kitchenkarrot.recipes.recipe.PlateRecipe;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import io.github.tt432.kitchenkarrot.registries.ModMenuTypes;
import io.github.tt432.kitchenkarrot.registries.RecipeTypes;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static final RecipeType<AirCompressorRecipe> AIR_COMPRESSOR = new RecipeType(new ResourceLocation("kitchenkarrot", "air_compressor"), AirCompressorRecipe.class);
    public static final RecipeType<CocktailRecipe> COCKTAIL = new RecipeType(new ResourceLocation("kitchenkarrot", "cocktail"), CocktailRecipe.class);
    public static final RecipeType<BrewingBarrelRecipe> BREWING_BARREL = new RecipeType(new ResourceLocation("kitchenkarrot", "brewing_barrel"), BrewingBarrelRecipe.class);
    public static final RecipeType<PlateRecipe> PLATE = new RecipeType(new ResourceLocation("kitchenkarrot", "plate"), PlateRecipe.class);
    public static final ResourceLocation UID = new ResourceLocation("kitchenkarrot", "jei_plugin");

    protected <C extends Container, T extends Recipe<C>> List<T> getRecipe(net.minecraft.world.item.crafting.RecipeType<T> recipeType) {
        return Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(recipeType);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new AirCompressorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CocktailRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BrewingBarrelRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PlateRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AIR_COMPRESSOR, this.getRecipe((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.AIR_COMPRESSOR.get()));
        registration.addRecipes(COCKTAIL, this.getRecipe((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.COCKTAIL.get()));
        registration.addRecipes(BREWING_BARREL, this.getRecipe((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.BREWING_BARREL.get()));
        registration.addRecipes(PLATE, this.getRecipe((net.minecraft.world.item.crafting.RecipeType)RecipeTypes.PLATE.get()));
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.GEM_CARROT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.kitchenkarrot.gem_carrot")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlockItems.FINE_SALT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.kitchenkarrot.fine_salt")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.PILLAGER_PIE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.kitchenkarrot.pillager_pie")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.WATER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.kitchenkarrot.water")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.SHAKER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.kitchenkarrot.shaker")});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlockItems.AIR_COMPRESSOR.get()), new RecipeType[]{AIR_COMPRESSOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.SHAKER.get()), new RecipeType[]{COCKTAIL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlockItems.BREWING_BARREL.get()), new RecipeType[]{BREWING_BARREL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.KNIFE.get()), new RecipeType[]{PLATE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AirCompressorGui.class, 105, 52, 21, 19, new RecipeType[]{AIR_COMPRESSOR});
        registration.addRecipeClickArea(BrewingBarrelGui.class, 133, 53, 4, 4, new RecipeType[]{BREWING_BARREL});
        registration.addRecipeClickArea(ShakerGui.class, 155, 61, 14, 16, new RecipeType[]{COCKTAIL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AirCompressorMenu.class, (MenuType)ModMenuTypes.AIR_COMPRESSOR.get(), AIR_COMPRESSOR, 36, 5, 0, 36);
        registration.addRecipeTransferHandler(ShakerMenu.class, (MenuType)ModMenuTypes.SHAKER.get(), COCKTAIL, 36, 5, 0, 36);
        registration.addRecipeTransferHandler(BrewingBarrelMenu.class, (MenuType)ModMenuTypes.BREWING_BARREL.get(), BREWING_BARREL, 36, 6, 0, 36);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.COCKTAIL.get(), (IIngredientSubtypeInterpreter)CocktailSubtypeInterpreter.INSTANCE);
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }
}

