/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.item;

import io.github.tt432.kitchenkarrot.item.EffectEntry;
import io.github.tt432.kitchenkarrot.item.FoodUtil;
import io.github.tt432.kitchenkarrot.item.ModItem;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModFood
extends ModItem {
    protected UseAnim foodType = UseAnim.EAT;
    protected Duration duration = Duration.Normal;
    protected EffectEntry[] effectEntries;
    protected Item returnItem;

    public ModFood(Item.Properties pProperties) {
        super(pProperties);
    }

    public ModFood(int nutrition, float saturation, EffectEntry ... effectEntries) {
        this(nutrition, saturation, false, effectEntries);
        this.effectEntries = effectEntries;
    }

    public ModFood(int nutrition, float saturation, boolean alwaysEat, EffectEntry ... effectEntries) {
        super(FoodUtil.effectFood(ModItems.defaultProperties(), nutrition, saturation, alwaysEat, effectEntries));
        this.effectEntries = effectEntries;
    }

    public ModFood(int nutrition, float saturation, int stackSize, EffectEntry ... effectEntries) {
        this(nutrition, saturation, stackSize, false, effectEntries);
        this.effectEntries = effectEntries;
    }

    public ModFood(int nutrition, float saturation, int stackSize, boolean alwaysEat, EffectEntry ... effectEntries) {
        super(FoodUtil.effectFood(ModItems.defaultProperties(), nutrition, saturation, alwaysEat, effectEntries).m_41487_(stackSize));
        this.effectEntries = effectEntries;
    }

    public static ModFood drinkItem(int nutrition, float saturation, EffectEntry ... effectEntries) {
        ModFood item = new ModFood(nutrition, saturation, true, effectEntries).setDrinkAnim();
        item.effectEntries = effectEntries;
        return item;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, tooltip, pIsAdvanced);
        if (this.effectEntries != null && this.effectEntries.length > 0) {
            PotionUtils.m_257410_(Arrays.stream(this.effectEntries).map(e -> e.effect.get()).toList(), tooltip, (float)1.0f);
        }
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return this.foodType;
    }

    public int m_8105_(ItemStack stack) {
        return this.duration.time;
    }

    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, LivingEntity livingEntity) {
        stack = livingEntity.m_5584_(level, stack);
        if (this.returnItem == null) {
            return stack;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_150109_().m_36054_(new ItemStack((ItemLike)this.returnItem));
        }
        return stack;
    }

    public ModFood setFoodType(@NotNull UseAnim foodType) {
        this.foodType = foodType;
        return this;
    }

    public ModFood setDrinkAnim() {
        this.setFoodType(UseAnim.DRINK);
        return this;
    }

    public ModFood setDuration(@NotNull Duration duration) {
        this.duration = duration;
        return this;
    }

    public ModFood setBowlFood() {
        this.setReturnItem(Items.f_42399_);
        return this;
    }

    public ModFood setBottleFood() {
        this.setReturnItem(Items.f_42590_);
        return this;
    }

    public ModFood setReturnItem(@NotNull Item item) {
        this.returnItem = item;
        return this;
    }

    public ModFood setEffectEntries(EffectEntry[] effectEntries) {
        this.effectEntries = effectEntries;
        return this;
    }

    public static enum Duration {
        SunflowerKelp(12),
        VeryFast(16),
        Fast(24),
        Normal(32),
        Slow(48),
        VerySlow(64),
        CurryUdon(96);

        private final int time;

        private Duration(int duration) {
            this.time = duration;
        }
    }
}

