/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.item;

import io.github.tt432.kitchenkarrot.capability.ShakerCapabilityProvider;
import io.github.tt432.kitchenkarrot.menu.ShakerMenu;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import io.github.tt432.kitchenkarrot.registries.ModSoundEvents;
import io.github.tt432.kitchenkarrot.util.SoundUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ShakerItem
extends Item {
    public ShakerItem() {
        super(ModItems.cocktailProperties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"info.kitchenkarrot.shaker1"));
        tooltip.add((Component)Component.m_237115_((String)"info.kitchenkarrot.shaker2"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pUsedHand == InteractionHand.MAIN_HAND) {
            if (pPlayer.m_6144_()) {
                if (!pLevel.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)new SimpleMenuProvider((id, inv, player) -> new ShakerMenu(id, inv), stack.m_41611_()));
                } else {
                    pPlayer.m_5496_((SoundEvent)ModSoundEvents.SHAKER_OPEN.get(), 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
                }
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
            }
            if (!ShakerItem.getFinish(stack)) {
                pPlayer.m_6672_(pUsedHand);
                if (pLevel.f_46443_) {
                    SoundUtil.shakerSound(pPlayer, pLevel);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        if (pLevel.f_46443_ && pEntity instanceof Player && (player = (Player)pEntity).m_21211_() != pStack) {
            Minecraft.m_91087_().m_91106_().m_120386_(((SoundEvent)ModSoundEvents.SHAKER.get()).m_11660_(), player.m_5720_());
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ShakerItem.setFinish(pStack, true);
            if (pLevel.f_46443_) {
                Minecraft.m_91087_().m_91106_().m_120386_(((SoundEvent)ModSoundEvents.SHAKER.get()).m_11660_(), player.m_5720_());
                pLivingEntity.m_5496_((SoundEvent)ModSoundEvents.COCKTAIL_COMPLETE.get(), 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
        return pStack;
    }

    public int m_8105_(ItemStack pStack) {
        return ShakerItem.getRecipeTime(pStack);
    }

    public static void setFinish(ItemStack stack, boolean finish) {
        stack.m_41784_().m_128379_("finish", finish);
    }

    public static boolean getFinish(ItemStack stack) {
        return stack.m_41784_().m_128471_("finish");
    }

    public static void setRecipeTime(ItemStack stack, int time) {
        stack.m_41784_().m_128405_("time", time);
    }

    public static int getRecipeTime(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("time") ? tag.m_128451_("time") : 0;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ShakerCapabilityProvider();
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag result = Objects.requireNonNullElse(super.getShareTag(stack), new CompoundTag());
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> result.m_128365_("items", (Tag)((ItemStackHandler)h).serializeNBT()));
        result.m_128379_("finish", ShakerItem.getFinish(stack));
        result.m_128405_("time", ShakerItem.getRecipeTime(stack));
        return result;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> ((ItemStackHandler)h).deserializeNBT(nbt.m_128469_("items")));
            ShakerItem.setFinish(stack, nbt.m_128471_("finish"));
            ShakerItem.setRecipeTime(stack, nbt.m_128451_("time"));
        }
    }

    public boolean m_142095_() {
        return false;
    }
}

