/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FluidPotCookRule1Copy<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final FluidPotCookRule1Copy INSTANCE = new FluidPotCookRule1Copy();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> FluidPotCookRule1Copy<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        boolean hasMaidRecs;
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasFluid = cookBeBase.hasFluid();
        if (!recMatch && hasFluid && hasInputAvailableSlot && this.hasFluidContainers(cookBeBase.getFluid(), cm)) {
            return true;
        }
        if (matchCookState && !recMatch && (hasMaidRecs = cm.hasMaidRecs(cookBeBase))) {
            return true;
        }
        boolean hasInputs = cookBeBase.hasInputs();
        if (!recMatch && hasInputs && hasInputAvailableSlot) {
            return true;
        }
        boolean hasContainer = cookBeBase.hasContainer();
        return !hasInputs && hasContainer && hasInputAvailableSlot;
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        ItemStack meal = cookBeBase.getMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        if (!meal.m_41619_()) {
            if (!nowContainer.m_41619_()) {
                cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            }
            ItemStack needContainer = cookBeBase.getNeedContainer();
            ItemStack outputAdditionItem = cm.getItem(needContainer);
            cookBeBase.insertContainer(outputAdditionItem);
            cookBeBase.markChanged();
        }
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_()) {
            cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
        }
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (!recMatch && hasInputs) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        if (!recMatch && !nowContainer.m_41619_()) {
            cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        if (matchCookState && !recMatch && cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            cookBeBase.insertFluidItems(maidRec.fluidItem(), itemInventory, inputInv);
            cookBeBase.insertInputs(maidRec, itemInventory);
            cookBeBase.markChanged();
            cm.getItemInventory().markDirty();
            recMatch = true;
        }
        FluidStack fluidStack = cookBeBase.getFluidStack();
        if (!recMatch && !fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            ItemStack fluidContainer = this.getFluidContainers(fluid, cm);
            cookBeBase.useItem(fluidContainer, () -> !fluidStack.isEmpty(), outputInv);
        }
    }
}

