/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.tea_aroma.boiling;

import cn.foggyhillside.tea_aroma.blocks.entities.KettleEntity;
import cn.foggyhillside.tea_aroma.items.KettleItem;
import cn.foggyhillside.tea_aroma.registry.ModItems;
import cn.foggyhillside.tea_aroma.registry.ModTags;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.AutoCraftGuideGeneratorRegister;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.ICookingGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonIdleAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.FailCraftGuideStepData;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.TargetUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.lang.TypeLang;
import com.github.wallev.maidsoulkitchen.compat.msm.tea_aroma.util.TeaBrewingFoamHelper;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonIdleAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;

@AutoCraftGuideGeneratorRegister(value=TaskInfo.MSM_TA_BOILING)
public class GeneratorTaBoilingGuide
implements ICookingGuideGenerator<KettleIngredient> {
    @Override
    public boolean isValidBlockInWorld(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return true;
    }

    @Override
    @TypeLang(en_us="Boiling water/milk", zh_cn="\u70e7\u6c34/\u70ed\u5976")
    @NotNull
    public ResourceLocation getType() {
        return VResourceLocation.createTypeMod(Mods.TA, "boiling");
    }

    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() && KettleEntity.isHeated((Level)level, (BlockPos)pos);
    }

    @Override
    public void generateSteps(BlockPos pos, Level level, KettleIngredient recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        CraftGuideOperator2.forEachSingleItem(realItems, itemStack -> {
            ItemStack craftingRemainingItem = itemStack.getCraftingRemainingItem();
            if (!craftingRemainingItem.m_41619_()) {
                craftGuide.addItemUse((ItemStack)itemStack, craftingRemainingItem);
            } else {
                craftGuide.addItemUse((ItemStack)itemStack);
            }
        });
        craftGuide.addStep(new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(), List.of(), EnchantCommonIdleAction.TYPE, ActionOptionSet.with((ActionOption)EnchantCommonIdleAction.OPTION_WAIT, (Object)true, (String)"200")));
        CraftGuideStepData failQueryKettle = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(), List.of(), CommonUseAction.TYPE);
        CraftGuideStepData idle = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(), List.of(), CommonIdleAction.TYPE);
        CompoundTag compoundTag = FailCraftGuideStepData.toCompoundTag(failQueryKettle, idle);
        craftGuide.addStep(new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(), outputs, EnchantCommonUseAction.TYPE, compoundTag));
    }

    @Override
    public int getRecipeTime(KettleIngredient recipe) {
        return 200;
    }

    @Override
    public void consumeRecipes(RecipeManager manager, Consumer<KettleIngredient> recipeConsumer) {
        Ingredient waterKettleInput = TeaBrewingFoamHelper.createNeedBoilingWaterKettle();
        recipeConsumer.accept(new KettleIngredient(waterKettleInput, KettleType.WATER));
        Ingredient milkKettleInput = TeaBrewingFoamHelper.createNeedBoilingMilkKettle();
        recipeConsumer.accept(new KettleIngredient(milkKettleInput, KettleType.MILK));
        Ingredient emptyWaterKettleInput = Ingredient.m_43927_((ItemStack[])new ItemStack[]{KettleItem.getEmptyKettle()});
        recipeConsumer.accept(new KettleIngredient(emptyWaterKettleInput, KettleType.EMPTY_WATER));
        Ingredient emptyMilkKettleInput = Ingredient.m_43927_((ItemStack[])new ItemStack[]{KettleItem.getEmptyKettle()});
        recipeConsumer.accept(new KettleIngredient(emptyMilkKettleInput, KettleType.EMPTY_MILK));
    }

    @Override
    public ResourceLocation getRecipeId(KettleIngredient recipe) {
        return VResourceLocation.createMod("boiling_" + recipe.type.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public List<Ingredient> getInputs(KettleIngredient recipe) {
        List<Ingredient> inputs = switch (recipe.type) {
            default -> throw new IncompatibleClassChangeError();
            case KettleType.WATER, KettleType.MILK -> List.of(recipe.ingredient);
            case KettleType.EMPTY_WATER -> List.of(recipe.ingredient, TeaBrewingFoamHelper.getWaters());
            case KettleType.EMPTY_MILK -> List.of(recipe.ingredient, Ingredient.m_204132_((TagKey)ModTags.MILK));
        };
        return inputs;
    }

    @Override
    public List<ItemStack> getOutputs(KettleIngredient recipe, RegistryAccess registryAccess) {
        ItemStack output = switch (recipe.type) {
            default -> throw new IncompatibleClassChangeError();
            case KettleType.WATER, KettleType.EMPTY_WATER -> KettleItem.getBoilingWaterKettle();
            case KettleType.MILK, KettleType.EMPTY_MILK -> KettleItem.getBoilingMilkKettle();
        };
        return List.of(output);
    }

    @Override
    public Item getBlockItemForTranslate() {
        return (Item)ModItems.KETTLE.get();
    }

    public record KettleIngredient(Ingredient ingredient, KettleType type) {
    }

    public static enum KettleType {
        WATER,
        MILK,
        EMPTY_WATER,
        EMPTY_MILK;

    }
}

